/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vibe.platform.server.netty4;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.atmosphere.vibe.platform.Action;
import org.atmosphere.vibe.platform.server.ServerHttpExchange;
import org.atmosphere.vibe.platform.server.ServerWebSocket;
import org.atmosphere.vibe.platform.server.netty4.NettyServerHttpExchange;
import org.atmosphere.vibe.platform.server.netty4.NettyServerWebSocket;

public class VibeServerCodec
extends ChannelInboundHandlerAdapter {
    private final Map<Channel, NettyServerHttpExchange> httpMap = new ConcurrentHashMap<Channel, NettyServerHttpExchange>();
    private final Map<Channel, NettyServerWebSocket> wsMap = new ConcurrentHashMap<Channel, NettyServerWebSocket>();
    private final Map<Channel, FullHttpRequest> wsReqMap = new ConcurrentHashMap<Channel, FullHttpRequest>();

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        NettyServerWebSocket ws;
        if (msg instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)msg;
            if (!this.accept(req)) {
                return;
            }
            if (req.getMethod() == HttpMethod.GET && req.headers().contains("Upgrade", "WebSocket", true)) {
                DefaultFullHttpRequest wsRequest = new DefaultFullHttpRequest(req.getProtocolVersion(), req.getMethod(), req.getUri());
                wsRequest.headers().set(req.headers());
                this.wsReqMap.put(ctx.channel(), (FullHttpRequest)wsRequest);
                ctx.pipeline().addFirst(new ChannelHandler[]{new ReadTimeoutHandler(5)});
            } else {
                NettyServerHttpExchange http = new NettyServerHttpExchange(ctx, req);
                this.httpMap.put(ctx.channel(), http);
                this.httpAction().on((Object)http);
            }
        } else if (msg instanceof HttpContent) {
            FullHttpRequest wsReq = this.wsReqMap.get(ctx.channel());
            if (wsReq != null) {
                wsReq.content().writeBytes(((HttpContent)msg).content());
                if (msg instanceof LastHttpContent) {
                    this.wsReqMap.remove(ctx.channel());
                    ctx.pipeline().remove(ReadTimeoutHandler.class);
                    WebSocketServerHandshakerFactory factory = new WebSocketServerHandshakerFactory(this.getWebSocketLocation(ctx.pipeline(), (HttpRequest)wsReq), null, true);
                    WebSocketServerHandshaker handshaker = factory.newHandshaker((HttpRequest)wsReq);
                    if (handshaker == null) {
                        WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
                    } else {
                        handshaker.handshake(ctx.channel(), wsReq);
                        NettyServerWebSocket ws2 = new NettyServerWebSocket(ctx, wsReq, handshaker);
                        this.wsMap.put(ctx.channel(), ws2);
                        this.wsAction().on((Object)ws2);
                    }
                }
            } else {
                NettyServerHttpExchange http = this.httpMap.get(ctx.channel());
                if (http != null) {
                    http.handleChunk((HttpContent)msg);
                }
            }
        } else if (msg instanceof WebSocketFrame && (ws = this.wsMap.get(ctx.channel())) != null) {
            ws.handleFrame((WebSocketFrame)msg);
        }
    }

    protected boolean accept(HttpRequest req) {
        return true;
    }

    private String getWebSocketLocation(ChannelPipeline pipeline, HttpRequest req) {
        return (pipeline.get(SslHandler.class) == null ? "ws://" : "wss://") + HttpHeaders.getHost((HttpMessage)req) + req.getUri();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        NettyServerWebSocket ws;
        NettyServerHttpExchange http = this.httpMap.get(ctx.channel());
        if (http != null) {
            http.handleError(cause);
        }
        if ((ws = this.wsMap.get(ctx.channel())) != null) {
            ws.handleError(cause);
        }
        ctx.close();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        NettyServerWebSocket ws;
        NettyServerHttpExchange http = this.httpMap.remove(ctx.channel());
        if (http != null) {
            http.handleClose();
        }
        if ((ws = this.wsMap.remove(ctx.channel())) != null) {
            ws.handleClose();
        }
        this.wsReqMap.remove(ctx.channel());
    }

    protected Action<ServerHttpExchange> httpAction() {
        throw new IllegalStateException("Actiont to receive ServerHttpExchange is not set");
    }

    public Action<ServerWebSocket> wsAction() {
        throw new IllegalStateException("Actiont to receive ServerWebSocket is not set");
    }
}

