/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vibe.platform.server.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;
import org.atmosphere.vibe.platform.HttpStatus;
import org.atmosphere.vibe.platform.server.AbstractServerHttpExchange;

public class NettyServerHttpExchange
extends AbstractServerHttpExchange {
    private final ChannelHandlerContext context;
    private final HttpRequest request;
    private final HttpResponse response;
    private boolean written;
    private Charset charset;

    public NettyServerHttpExchange(ChannelHandlerContext context, HttpRequest request) {
        this.context = context;
        this.request = request;
        this.response = new DefaultHttpResponse(request.getProtocolVersion(), HttpResponseStatus.OK, false);
        this.response.headers().set("Transfer-Encoding", (Object)"chunked");
    }

    void handleError(Throwable cause) {
        this.errorActions.fire((Object)cause);
    }

    void handleClose() {
        this.closeActions.fire();
    }

    public String uri() {
        return this.request.getUri();
    }

    public String method() {
        return this.request.getMethod().toString();
    }

    public Set<String> headerNames() {
        return this.request.headers().names();
    }

    public List<String> headers(String name) {
        return this.request.headers().getAll(name);
    }

    protected void readAsText() {
        int idx;
        String charsetName = "ISO-8859-1";
        String contentType = this.request.headers().get("content-type");
        if (contentType != null && (idx = contentType.indexOf("charset=")) != -1) {
            charsetName = contentType.substring(idx + "charset=".length());
        }
        this.charset = Charset.forName(charsetName);
    }

    protected void readAsBinary() {
    }

    void handleChunk(HttpContent chunk) {
        this.read();
        ByteBuf buf = chunk.content();
        if (buf.isReadable()) {
            if (this.charset != null) {
                this.chunkActions.fire((Object)buf.toString(this.charset));
            } else {
                this.chunkActions.fire((Object)buf.nioBuffer());
            }
        }
        if (chunk instanceof LastHttpContent) {
            this.endActions.fire();
        }
    }

    protected void doSetStatus(HttpStatus status) {
        this.response.setStatus(new HttpResponseStatus(status.code(), status.reason()));
    }

    protected void doSetHeader(String name, String value) {
        this.response.headers().set(name, (Object)value);
    }

    protected void doWrite(String data) {
        byte[] bytes = data.getBytes(Charset.forName("UTF-8"));
        ByteBuf buf = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.buffer((int)bytes.length)).writeBytes(bytes);
        this.doWrite(buf);
    }

    protected void doWrite(ByteBuffer byteBuffer) {
        ByteBuf buf = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.wrappedBuffer((ByteBuffer)byteBuffer));
        this.doWrite(buf);
    }

    private void doWrite(ByteBuf buf) {
        if (!this.written) {
            this.written = true;
            this.context.write((Object)this.response);
        }
        this.context.writeAndFlush((Object)buf);
    }

    protected void doEnd() {
        if (!this.written) {
            this.written = true;
            this.context.write((Object)this.response);
        }
        this.context.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)(ChannelHandlerContext.class.isAssignableFrom(clazz) ? clazz.cast(this.context) : (HttpRequest.class.isAssignableFrom(clazz) ? clazz.cast(this.request) : (HttpResponse.class.isAssignableFrom(clazz) ? clazz.cast(this.response) : null)));
    }
}

