/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vibe.platform.bridge.netty4;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.atmosphere.vibe.platform.action.Action;
import org.atmosphere.vibe.platform.action.Actions;
import org.atmosphere.vibe.platform.action.ConcurrentActions;
import org.atmosphere.vibe.platform.bridge.netty4.NettyServerHttpExchange;
import org.atmosphere.vibe.platform.bridge.netty4.NettyServerWebSocket;
import org.atmosphere.vibe.platform.http.ServerHttpExchange;
import org.atmosphere.vibe.platform.ws.ServerWebSocket;

public class VibeServerCodec
extends ChannelInboundHandlerAdapter {
    private Actions<ServerHttpExchange> httpActions = new ConcurrentActions();
    private Actions<ServerWebSocket> wsActions = new ConcurrentActions();
    private Map<Channel, NettyServerHttpExchange> httpMap = new ConcurrentHashMap<Channel, NettyServerHttpExchange>();
    private Map<Channel, NettyServerWebSocket> wsMap = new ConcurrentHashMap<Channel, NettyServerWebSocket>();
    private Map<Channel, FullHttpRequest> wsReqMap = new ConcurrentHashMap<Channel, FullHttpRequest>();

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        NettyServerWebSocket ws;
        if (msg instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)msg;
            if (!this.accept(req)) {
                ctx.fireChannelRead(msg);
                return;
            }
            if (req.getMethod() == HttpMethod.GET && req.headers().contains("Upgrade", "WebSocket", true)) {
                DefaultFullHttpRequest wsRequest = new DefaultFullHttpRequest(req.getProtocolVersion(), req.getMethod(), req.getUri());
                wsRequest.headers().set(req.headers());
                this.wsReqMap.put(ctx.channel(), (FullHttpRequest)wsRequest);
                ctx.pipeline().addFirst(new ChannelHandler[]{new ReadTimeoutHandler(5)});
            } else {
                NettyServerHttpExchange http = new NettyServerHttpExchange(ctx, req);
                this.httpMap.put(ctx.channel(), http);
                this.httpActions.fire((Object)http);
            }
        } else if (msg instanceof HttpContent) {
            FullHttpRequest wsReq = this.wsReqMap.get(ctx.channel());
            if (wsReq != null) {
                wsReq.content().writeBytes(((HttpContent)msg).content());
                if (msg instanceof LastHttpContent) {
                    this.wsReqMap.remove(ctx.channel());
                    ctx.pipeline().remove(ReadTimeoutHandler.class);
                    WebSocketServerHandshakerFactory factory = new WebSocketServerHandshakerFactory(this.getWebSocketLocation(ctx.pipeline(), (HttpRequest)wsReq), null, true);
                    WebSocketServerHandshaker handshaker = factory.newHandshaker((HttpRequest)wsReq);
                    if (handshaker == null) {
                        WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
                    } else {
                        handshaker.handshake(ctx.channel(), wsReq);
                        NettyServerWebSocket ws2 = new NettyServerWebSocket(ctx, wsReq, handshaker);
                        this.wsMap.put(ctx.channel(), ws2);
                        this.wsActions.fire((Object)ws2);
                    }
                }
            } else {
                NettyServerHttpExchange http = this.httpMap.get(ctx.channel());
                if (http != null) {
                    http.handleChunk((HttpContent)msg);
                }
            }
        } else if (msg instanceof WebSocketFrame && (ws = this.wsMap.get(ctx.channel())) != null) {
            ws.handleFrame((WebSocketFrame)msg);
        }
    }

    protected boolean accept(HttpRequest req) {
        return true;
    }

    private String getWebSocketLocation(ChannelPipeline pipeline, HttpRequest req) {
        return (pipeline.get(SslHandler.class) == null ? "ws://" : "wss://") + HttpHeaders.getHost((HttpMessage)req) + req.getUri();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        NettyServerWebSocket ws;
        NettyServerHttpExchange http = this.httpMap.get(ctx.channel());
        if (http != null) {
            http.handleError(cause);
        }
        if ((ws = this.wsMap.get(ctx.channel())) != null) {
            ws.handleError(cause);
        }
        ctx.close();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        NettyServerWebSocket ws;
        NettyServerHttpExchange http = this.httpMap.remove(ctx.channel());
        if (http != null) {
            http.handleClose();
        }
        if ((ws = this.wsMap.remove(ctx.channel())) != null) {
            ws.handleClose();
        }
        this.wsReqMap.remove(ctx.channel());
    }

    public VibeServerCodec httpAction(Action<ServerHttpExchange> action) {
        this.httpActions.add(action);
        return this;
    }

    public VibeServerCodec wsAction(Action<ServerWebSocket> action) {
        this.wsActions.add(action);
        return this;
    }
}

