/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vertx.samples.chat;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.atmosphere.config.service.DeliverTo;
import org.atmosphere.config.service.Disconnect;
import org.atmosphere.config.service.ManagedService;
import org.atmosphere.config.service.Message;
import org.atmosphere.config.service.PathParam;
import org.atmosphere.config.service.Ready;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceFactory;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.MetaBroadcaster;
import org.atmosphere.vertx.samples.chat.ChatProtocol;
import org.atmosphere.vertx.samples.chat.JacksonEncoder;
import org.atmosphere.vertx.samples.chat.ProtocolDecoder;
import org.atmosphere.vertx.samples.chat.UserDecoder;
import org.atmosphere.vertx.samples.chat.UserMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedService(path="/chat/{room: [a-zA-Z][a-zA-Z_0-9]*}")
public class ChatRoom {
    private final Logger logger = LoggerFactory.getLogger(ChatRoom.class);
    private final ConcurrentHashMap<String, String> users = new ConcurrentHashMap();
    private static final String CHAT = "/chat/";
    @PathParam(value="room")
    private String chatroomName;
    @Inject
    private BroadcasterFactory factory;
    @Inject
    private AtmosphereResourceFactory resourceFactory;
    @Inject
    private MetaBroadcaster metaBroadcaster;

    @Ready(encoders={JacksonEncoder.class})
    @DeliverTo(value=DeliverTo.DELIVER_TO.ALL)
    public ChatProtocol onReady(AtmosphereResource r) {
        this.logger.info("Browser {} connected.", (Object)r.uuid());
        return new ChatProtocol(this.users.keySet(), ChatRoom.getRooms(this.factory.lookupAll()));
    }

    private static Collection<String> getRooms(Collection<Broadcaster> broadcasters) {
        ArrayList<String> result = new ArrayList<String>();
        for (Broadcaster broadcaster : broadcasters) {
            if ("/*".equals(broadcaster.getID())) continue;
            result.add(broadcaster.getID().split("/")[2]);
        }
        return result;
    }

    @Disconnect
    public void onDisconnect(AtmosphereResourceEvent event) {
        if (event.isCancelled()) {
            this.users.values().remove(event.getResource().uuid());
            this.logger.info("Browser {} unexpectedly disconnected", (Object)event.getResource().uuid());
        } else if (event.isClosedByClient()) {
            this.logger.info("Browser {} closed the connection", (Object)event.getResource().uuid());
        }
    }

    @Message(encoders={JacksonEncoder.class}, decoders={ProtocolDecoder.class})
    public ChatProtocol onMessage(ChatProtocol message) throws IOException {
        if (!this.users.containsKey(message.getAuthor())) {
            this.users.put(message.getAuthor(), message.getUuid());
            return new ChatProtocol(message.getAuthor(), " entered room " + this.chatroomName, this.users.keySet(), ChatRoom.getRooms(this.factory.lookupAll()));
        }
        if (message.getMessage().contains("disconnecting")) {
            this.users.remove(message.getAuthor());
            return new ChatProtocol(message.getAuthor(), " disconnected from room " + this.chatroomName, this.users.keySet(), ChatRoom.getRooms(this.factory.lookupAll()));
        }
        message.setUsers(this.users.keySet());
        this.logger.info("{} just send {}", (Object)message.getAuthor(), (Object)message.getMessage());
        return new ChatProtocol(message.getAuthor(), message.getMessage(), this.users.keySet(), ChatRoom.getRooms(this.factory.lookupAll()));
    }

    @Message(decoders={UserDecoder.class})
    public void onPrivateMessage(UserMessage user) throws IOException {
        String userUUID = this.users.get(user.getUser());
        if (userUUID != null) {
            AtmosphereResource r = this.resourceFactory.find(userUUID);
            if (r != null) {
                ChatProtocol m = new ChatProtocol(user.getUser(), " sent you a private message: " + user.getMessage().split(":")[1], this.users.keySet(), ChatRoom.getRooms(this.factory.lookupAll()));
                if (!user.getUser().equalsIgnoreCase("all")) {
                    this.factory.lookup((Object)(CHAT + this.chatroomName)).broadcast((Object)m, r);
                }
            }
        } else {
            ChatProtocol m = new ChatProtocol(user.getUser(), " sent a message to all chatroom: " + user.getMessage().split(":")[1], this.users.keySet(), ChatRoom.getRooms(this.factory.lookupAll()));
            this.metaBroadcaster.broadcastTo("/*", (Object)m);
        }
    }
}

