/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vertx.samples.chat;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import org.atmosphere.vertx.VertxAtmosphere;
import org.atmosphere.vertx.samples.chat.ChatRoom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxChatServer
extends AbstractVerticle {
    private static final Logger logger = LoggerFactory.getLogger(VertxChatServer.class);
    private HttpServer httpServer;
    private Vertx vertx;

    public void init(Vertx vertx, Context context) {
        this.vertx = vertx;
        this.httpServer = vertx.createHttpServer();
    }

    public void start(Future<Void> future) throws Exception {
        VertxAtmosphere.Builder b = new VertxAtmosphere.Builder();
        b.resource(ChatRoom.class).httpServer(this.httpServer).url("/chat/:room").webroot("src/main/java/org/atmosphere/vertx/samples/webroot/").vertx(this.vertx).build();
        this.httpServer.listen(8080);
    }

    public void stop(Future<Void> future) throws Exception {
        this.httpServer.close();
    }
}

