/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vertx.samples.chat;

import org.atmosphere.vertx.VertxAtmosphere;
import org.atmosphere.vertx.samples.chat.ChatRoom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.http.HttpServer;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.deploy.Verticle;

public class VertxChatServer
extends Verticle {
    private static final Logger logger = LoggerFactory.getLogger(VertxChatServer.class);

    public void start() throws Exception {
        VertxAtmosphere.Builder b = new VertxAtmosphere.Builder();
        HttpServer httpServer = this.vertx.createHttpServer();
        httpServer.requestHandler((Handler)new Handler<HttpServerRequest>(){

            public void handle(HttpServerRequest req) {
                String path = req.path;
                if (path.equals("/")) {
                    path = "/index.html";
                }
                logger.info("Servicing request {}", (Object)path);
                req.response.sendFile("src/main/resources" + path);
            }
        });
        b.resource(ChatRoom.class).httpServer(httpServer).url("/chat/:room").build();
        httpServer.listen(8080);
    }
}

