/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.gwt20.server;

import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyProvider;
import com.google.gwt.user.server.rpc.impl.ServerSerializationStreamReader;
import com.google.gwt.user.server.rpc.impl.ServerSerializationStreamWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.TreeSet;
import org.atmosphere.gwt20.server.SerializationException;
import org.atmosphere.gwt20.server.ServerSerializer;
import org.atmosphere.gwt20.server.ServerSerializerProvider;

public class GwtRpcUtil
implements ServerSerializerProvider {
    public static final String SERIALIZER_PROVIDER_NAME = "GwtRpc";
    private static Class<? extends Annotation> JDO_PERSISTENCE_CAPABLE_ANNOTATION = null;
    private static Method JDO_PERSISTENCE_CAPABLE_DETACHABLE_METHOD;
    private static Class<? extends Annotation> JPA_ENTITY_ANNOTATION;
    private static final SerializationPolicy serializationPolicy;
    private static final SerializationPolicyProvider serializationPolicyProvider;

    static boolean hasJpaAnnotation(Class<?> clazz) {
        if (JPA_ENTITY_ANNOTATION == null) {
            return false;
        }
        return clazz.getAnnotation(JPA_ENTITY_ANNOTATION) != null;
    }

    static boolean hasJdoAnnotation(Class<?> clazz) {
        if (JDO_PERSISTENCE_CAPABLE_ANNOTATION == null) {
            return false;
        }
        Annotation annotation = clazz.getAnnotation(JDO_PERSISTENCE_CAPABLE_ANNOTATION);
        if (annotation == null) {
            return false;
        }
        try {
            Object value = JDO_PERSISTENCE_CAPABLE_DETACHABLE_METHOD.invoke((Object)annotation, (Object[])null);
            if (value instanceof String) {
                return "true".equalsIgnoreCase((String)value);
            }
            return false;
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public String getName() {
        return SERIALIZER_PROVIDER_NAME;
    }

    @Override
    public ServerSerializer getServerSerializer() {
        return new ServerSerializer(){

            @Override
            public Object deserialize(String message) throws SerializationException {
                try {
                    return GwtRpcUtil.deserialize(message);
                }
                catch (com.google.gwt.user.client.rpc.SerializationException ex) {
                    throw new SerializationException(ex.getMessage(), ex);
                }
            }

            @Override
            public String serialize(Object message) throws SerializationException {
                try {
                    return GwtRpcUtil.serialize(message);
                }
                catch (com.google.gwt.user.client.rpc.SerializationException ex) {
                    throw new SerializationException(ex.getMessage(), ex);
                }
            }
        };
    }

    public static SerializationPolicyProvider getSerializationPolicyProvider() {
        return serializationPolicyProvider;
    }

    public static SerializationPolicy getSerializationPolicy() {
        return serializationPolicy;
    }

    public static String streamToString(InputStream in, String charset) throws IOException, UnsupportedEncodingException {
        return GwtRpcUtil.readerToString(new BufferedReader(new InputStreamReader(in, charset)));
    }

    public static String readerToString(BufferedReader r) throws IOException {
        StringBuilder data = new StringBuilder();
        char[] buf = new char[5120];
        int read = -1;
        while ((read = r.read(buf)) > 0) {
            data.append(buf, 0, read);
        }
        return data.toString();
    }

    public static Object deserialize(String data) throws com.google.gwt.user.client.rpc.SerializationException {
        ServerSerializationStreamReader reader = new ServerSerializationStreamReader(GwtRpcUtil.class.getClassLoader(), GwtRpcUtil.getSerializationPolicyProvider());
        reader.prepareToRead(data);
        return reader.readObject();
    }

    public static String serialize(Object message) throws com.google.gwt.user.client.rpc.SerializationException {
        ServerSerializationStreamWriter streamWriter = new ServerSerializationStreamWriter(GwtRpcUtil.getSerializationPolicy());
        streamWriter.prepareToWrite();
        streamWriter.writeObject(message);
        return streamWriter.toString();
    }

    static {
        JPA_ENTITY_ANNOTATION = null;
        try {
            JDO_PERSISTENCE_CAPABLE_ANNOTATION = Class.forName("javax.jdo.annotations.PersistenceCapable").asSubclass(Annotation.class);
            JDO_PERSISTENCE_CAPABLE_DETACHABLE_METHOD = JDO_PERSISTENCE_CAPABLE_ANNOTATION.getDeclaredMethod("detachable", null);
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchMethodException e) {
            JDO_PERSISTENCE_CAPABLE_ANNOTATION = null;
        }
        try {
            JPA_ENTITY_ANNOTATION = Class.forName("javax.persistence.Entity").asSubclass(Annotation.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        serializationPolicy = new SerializationPolicy(){

            public Set<String> getClientFieldNamesForEnhancedClass(Class<?> clazz) {
                if (GwtRpcUtil.hasJpaAnnotation(clazz) || GwtRpcUtil.hasJdoAnnotation(clazz)) {
                    TreeSet<String> fieldNames = new TreeSet<String>();
                    for (Field f : clazz.getDeclaredFields()) {
                        fieldNames.add(f.getName());
                    }
                    return fieldNames;
                }
                return null;
            }

            public boolean shouldDeserializeFields(Class<?> clazz) {
                return Object.class != clazz;
            }

            public boolean shouldSerializeFields(Class<?> clazz) {
                return Object.class != clazz;
            }

            public void validateDeserialize(Class<?> clazz) {
            }

            public void validateSerialize(Class<?> clazz) {
            }
        };
        serializationPolicyProvider = new SerializationPolicyProvider(){

            public SerializationPolicy getSerializationPolicy(String moduleBaseURL, String serializationPolicyStrongName) {
                return serializationPolicy;
            }
        };
    }
}

