/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.gwt20.server;

import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyProvider;
import com.google.gwt.user.server.rpc.impl.ServerSerializationStreamReader;
import com.google.gwt.user.server.rpc.impl.ServerSerializationStreamWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.atmosphere.gwt20.server.SerializationException;
import org.atmosphere.gwt20.server.ServerSerializer;
import org.atmosphere.gwt20.server.ServerSerializerProvider;

public class GwtRpcUtil
implements ServerSerializerProvider {
    public static final String SERIALIZER_PROVIDER_NAME = "GwtRpc";
    private static final SerializationPolicy serializationPolicy = new SerializationPolicy(){

        public boolean shouldDeserializeFields(Class<?> clazz) {
            return Object.class != clazz;
        }

        public boolean shouldSerializeFields(Class<?> clazz) {
            return Object.class != clazz;
        }

        public void validateDeserialize(Class<?> clazz) {
        }

        public void validateSerialize(Class<?> clazz) {
        }
    };
    private static final SerializationPolicyProvider serializationPolicyProvider = new SerializationPolicyProvider(){

        public SerializationPolicy getSerializationPolicy(String moduleBaseURL, String serializationPolicyStrongName) {
            return serializationPolicy;
        }
    };

    @Override
    public String getName() {
        return SERIALIZER_PROVIDER_NAME;
    }

    @Override
    public ServerSerializer getServerSerializer() {
        return new ServerSerializer(){

            @Override
            public Object deserialize(String message) throws SerializationException {
                try {
                    return GwtRpcUtil.deserialize(message);
                }
                catch (com.google.gwt.user.client.rpc.SerializationException ex) {
                    throw new SerializationException(ex.getMessage(), ex);
                }
            }

            @Override
            public String serialize(Object message) throws SerializationException {
                try {
                    return GwtRpcUtil.serialize(message);
                }
                catch (com.google.gwt.user.client.rpc.SerializationException ex) {
                    throw new SerializationException(ex.getMessage(), ex);
                }
            }
        };
    }

    public static SerializationPolicyProvider getSerializationPolicyProvider() {
        return serializationPolicyProvider;
    }

    public static SerializationPolicy getSerializationPolicy() {
        return serializationPolicy;
    }

    public static String streamToString(InputStream in, String charset) throws IOException, UnsupportedEncodingException {
        return GwtRpcUtil.readerToString(new BufferedReader(new InputStreamReader(in, charset)));
    }

    public static String readerToString(BufferedReader r) throws IOException {
        StringBuilder data = new StringBuilder();
        char[] buf = new char[5120];
        int read = -1;
        while ((read = r.read(buf)) > 0) {
            data.append(buf, 0, read);
        }
        return data.toString();
    }

    public static Object deserialize(String data) throws com.google.gwt.user.client.rpc.SerializationException {
        ServerSerializationStreamReader reader = new ServerSerializationStreamReader(GwtRpcUtil.class.getClassLoader(), GwtRpcUtil.getSerializationPolicyProvider());
        reader.prepareToRead(data);
        return reader.readObject();
    }

    public static String serialize(Object message) throws com.google.gwt.user.client.rpc.SerializationException {
        ServerSerializationStreamWriter streamWriter = new ServerSerializationStreamWriter(GwtRpcUtil.getSerializationPolicy());
        streamWriter.prepareToWrite();
        streamWriter.writeObject(message);
        return streamWriter.toString();
    }
}

