/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.jersey;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.Trackable;
import org.atmosphere.jersey.TrackableResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackableSession {
    private static final Logger logger = LoggerFactory.getLogger(TrackableSession.class);
    private static final TrackableSession factory = new TrackableSession();
    private final ConcurrentHashMap<String, TrackableResource> factoryCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, CountDownLatch> pendingLock = new ConcurrentHashMap();
    private final AliveChecker aliveChecker = new AliveChecker();

    private TrackableSession() {
    }

    public static TrackableSession getDefault() {
        return factory;
    }

    public void track(TrackableResource<? extends Trackable> trackableResource) {
        logger.trace("Tracking {}", (Object)trackableResource.trackingID());
        this.factoryCache.put(trackableResource.trackingID(), trackableResource);
        CountDownLatch latch = this.pendingLock.remove(trackableResource.trackingID());
        if (latch != null) {
            latch.countDown();
        }
    }

    public TrackableResource<? extends Trackable> lookup(String trackingID) {
        TrackableResource t = this.factoryCache.get(trackingID);
        if (t != null && t.resource() != null && AtmosphereResource.class.isAssignableFrom(t.resource().getClass())) {
            ((AtmosphereResource)AtmosphereResource.class.cast(t.resource())).addEventListener((AtmosphereResourceEventListener)this.aliveChecker);
        }
        return t;
    }

    public TrackableResource<? extends Trackable> lookupAndWait(String trackingID) {
        logger.debug("Lookup trackinID {}", (Object)trackingID);
        TrackableResource r = this.factoryCache.get(trackingID);
        if (r == null) {
            CountDownLatch latch = new CountDownLatch(1);
            this.pendingLock.put(trackingID, latch);
            try {
                if (!latch.await(5L, TimeUnit.SECONDS)) {
                    // empty if block
                }
                this.pendingLock.remove(trackingID);
            }
            catch (InterruptedException e) {
                logger.trace("", (Throwable)e);
            }
        }
        return this.factoryCache.get(trackingID);
    }

    private static final class AliveChecker
    extends AtmosphereResourceEventListenerAdapter {
        private AliveChecker() {
        }

        public void onResume(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) {
            String id = ((HttpServletRequest)event.getResource().getRequest()).getHeader("X-Atmosphere-tracking-id");
            if (id != null) {
                factory.factoryCache.remove(id);
            }
        }

        public void onDisconnect(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) {
            String id = ((HttpServletRequest)event.getResource().getRequest()).getHeader("X-Atmosphere-tracking-id");
            if (id != null) {
                factory.factoryCache.remove(id);
            }
        }
    }
}

