/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.jersey;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.atmosphere.cpr.Trackable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackableResource<T extends Trackable> {
    private static final Logger logger = LoggerFactory.getLogger(TrackableResource.class);
    private final Class<T> type;
    private T resource;
    private String trackingID = null;
    private final Object entity;
    private final CountDownLatch latch = new CountDownLatch(1);

    public TrackableResource(Class<T> type, Object entity) {
        this.type = type;
        this.entity = entity;
    }

    public TrackableResource(Class<T> type, String trackingID, Object entity) {
        this.type = type;
        this.trackingID = trackingID;
        this.entity = entity;
    }

    protected void setResource(Trackable resource) {
        if (!this.type.isAssignableFrom(resource.getClass())) {
            throw new IllegalStateException(String.format("Unassignable %s to %s", this.type.toString(), resource.getClass().toString()));
        }
        this.latch.countDown();
        this.resource = (Trackable)this.type.cast(resource);
    }

    protected void setTrackingID(String trackingID) {
        this.trackingID = trackingID;
    }

    public T resource() {
        try {
            this.latch.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.trace("", (Throwable)e);
        }
        return this.resource;
    }

    public Class<T> type() {
        return this.type;
    }

    public String trackingID() {
        return this.trackingID;
    }

    public Object entity() {
        return this.entity;
    }
}

