/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.jersey;

import com.sun.jersey.spi.StringReader;
import com.sun.jersey.spi.StringReaderProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.cpr.Trackable;
import org.atmosphere.jersey.AtmosphereFilter;
import org.atmosphere.jersey.TrackableResource;
import org.atmosphere.jersey.TrackableSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereProviders {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereProviders.class);

    public static class TrackableResourceProvider
    implements StringReaderProvider {
        @Context
        HttpServletRequest req;

        public StringReader getStringReader(Class type, Type genericType, Annotation[] annotations) {
            if (TrackableResource.class.isAssignableFrom(type)) {
                return new TrackableResourceStringReader();
            }
            return null;
        }

        @StringReader.ValidateDefaultValue(value=false)
        public class TrackableResourceStringReader
        implements StringReader {
            public Object fromString(String topic) {
                TrackableResource<? extends Trackable> trackableResource = null;
                try {
                    String trackingId = TrackableResourceProvider.this.req.getHeader("X-Atmosphere-tracking-id");
                    if (trackingId == null) {
                        trackingId = (String)TrackableResourceProvider.this.req.getAttribute("X-Atmosphere-tracking-id");
                    }
                    if (trackingId != null) {
                        trackableResource = TrackableSession.getDefault().lookup(trackingId);
                        if (TrackableResourceProvider.this.req.getAttribute(ApplicationConfig.SUPPORT_TRACKABLE) != null) {
                            AtmosphereResource r = (AtmosphereResource)TrackableResourceProvider.this.req.getAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE);
                            if (trackableResource == null) {
                                trackableResource = new TrackableResource<AtmosphereResourceImpl>(AtmosphereResourceImpl.class, trackingId, "");
                                trackableResource.setResource((Trackable)r);
                            }
                            logger.trace("Tracking resource of AtmosphereResource {} with {}", (Object)r.hashCode(), (Object)trackingId);
                        }
                        TrackableResourceProvider.this.req.setAttribute(AtmosphereFilter.INJECTED_TRACKABLE, trackableResource);
                    }
                }
                catch (Throwable ex) {
                    throw new WebApplicationException(ex);
                }
                return trackableResource;
            }
        }
    }

    public static class BroadcasterProvider
    implements StringReaderProvider {
        @Context
        HttpServletRequest req;

        public StringReader getStringReader(Class type, Type genericType, Annotation[] annotations) {
            if (Broadcaster.class.isAssignableFrom(type)) {
                return new BroadcasterStringReader();
            }
            return null;
        }

        @StringReader.ValidateDefaultValue(value=false)
        public class BroadcasterStringReader
        implements StringReader {
            public Object fromString(String topic) {
                Broadcaster broadcaster;
                try {
                    Class<?> c;
                    AtmosphereResource r = (AtmosphereResource)BroadcasterProvider.this.req.getAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE);
                    BroadcasterFactory bp = (BroadcasterFactory)BroadcasterProvider.this.req.getAttribute(ApplicationConfig.BROADCASTER_FACTORY);
                    try {
                        c = Class.forName((String)BroadcasterProvider.this.req.getAttribute(ApplicationConfig.BROADCASTER_CLASS));
                    }
                    catch (Throwable e) {
                        throw new IllegalStateException(e.getMessage());
                    }
                    broadcaster = bp.lookup(c, (Object)topic, true);
                }
                catch (Throwable ex) {
                    throw new WebApplicationException(ex);
                }
                logger.trace("Injected Broadcaster {}", (Object)broadcaster);
                BroadcasterProvider.this.req.setAttribute(AtmosphereFilter.INJECTED_BROADCASTER, (Object)broadcaster);
                return broadcaster;
            }
        }
    }
}

