/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.gwt.server.impl;

import com.google.gwt.rpc.server.ClientOracle;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.atmosphere.cpr.AtmosphereEventLifecycle;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.Serializer;
import org.atmosphere.gwt.server.AtmosphereGwtHandler;
import org.atmosphere.gwt.server.GwtAtmosphereResource;
import org.atmosphere.gwt.server.GwtResponseWriter;
import org.atmosphere.gwt.server.impl.GwtResponseWriterImpl;
import org.atmosphere.gwt.server.impl.HTTPRequestResponseWriter;
import org.atmosphere.gwt.server.impl.IEHTMLFileResponseWriter;
import org.atmosphere.gwt.server.impl.IEXDomainRequestResponseWriter;
import org.atmosphere.gwt.server.impl.IFrameResponseWriter;
import org.atmosphere.gwt.server.impl.OperaEventSourceResponseWriter;
import org.atmosphere.gwt.server.impl.RPCUtil;
import org.atmosphere.gwt.server.impl.WebsocketResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GwtAtmosphereResourceImpl
implements GwtAtmosphereResource {
    public static final String HEARTBEAT_MESSAGE = "4dc5bdb9-edc8-4edf-8833-ab478326d8c9";
    private static final long WARMUP_TIME = 10000L;
    private long startTime = System.currentTimeMillis();
    private final GwtResponseWriterImpl writer;
    private AtmosphereResource<HttpServletRequest, HttpServletResponse> atmResource;
    private final int heartBeatInterval;
    private AtmosphereGwtHandler atmosphereHandler;
    private boolean suspended = false;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Runnable heartBeatTask = new Runnable(){

        @Override
        public void run() {
            if (GwtAtmosphereResourceImpl.this.isAlive()) {
                GwtAtmosphereResourceImpl.this.broadcast((Serializable)((Object)GwtAtmosphereResourceImpl.HEARTBEAT_MESSAGE));
            }
        }
    };
    private final Serializer serializer = new Serializer(){

        public void write(OutputStream out, Object o) throws IOException {
            if (o instanceof Serializable) {
                try {
                    GwtAtmosphereResourceImpl.this.writer.write((Serializable)o);
                }
                catch (IOException e) {
                    if (GwtAtmosphereResourceImpl.this.writer.isTerminated()) {
                        GwtAtmosphereResourceImpl.this.logger.debug("broadcast failed, connection terminated:" + e.getMessage(), (Throwable)e);
                    }
                    throw e;
                }
            } else if (o instanceof List) {
                List list = (List)o;
                if (list.size() > 0) {
                    if (!(list.get(0) instanceof Serializable)) {
                        throw new IOException("Failed to write a list of objects that are not serializable");
                    }
                    GwtAtmosphereResourceImpl.this.writer.write((List)o);
                }
            } else {
                GwtAtmosphereResourceImpl.this.logger.warn("Failed to write an object that is not serializable");
            }
        }
    };
    private final AtmosphereResourceEventListener eventListener = new AtmosphereResourceEventListener(){

        public void onSuspend(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> are) {
            GwtAtmosphereResourceImpl.this.suspended = true;
        }

        public void onResume(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) {
            GwtAtmosphereResourceImpl.this.suspended = false;
            GwtAtmosphereResourceImpl.this.writer.setTerminated(false);
        }

        public void onDisconnect(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) {
            GwtAtmosphereResourceImpl.this.suspended = false;
            GwtAtmosphereResourceImpl.this.writer.setTerminated(false);
        }

        public void onBroadcast(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) {
        }

        public void onThrowable(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) {
        }
    };

    public GwtAtmosphereResourceImpl(AtmosphereResource<HttpServletRequest, HttpServletResponse> resource, AtmosphereGwtHandler servlet, int heartBeatInterval) throws IOException {
        this.atmosphereHandler = servlet;
        this.atmResource = resource;
        this.heartBeatInterval = heartBeatInterval;
        this.writer = this.createResponseWriter();
        ((HttpServletRequest)resource.getRequest()).setAttribute(GwtAtmosphereResource.class.getName(), (Object)this);
    }

    @Override
    public Broadcaster getBroadcaster() {
        return this.atmResource.getBroadcaster();
    }

    @Override
    public HttpSession getSession() {
        return ((HttpServletRequest)this.atmResource.getRequest()).getSession();
    }

    @Override
    public HttpSession getSession(boolean create) {
        return ((HttpServletRequest)this.atmResource.getRequest()).getSession(create);
    }

    GwtResponseWriter getResponseWriter() {
        return this.writer;
    }

    @Override
    public int getHeartBeatInterval() {
        return this.heartBeatInterval;
    }

    @Override
    public void broadcast(Serializable message) {
        this.getBroadcaster().broadcast((Object)message, this.atmResource);
    }

    @Override
    public void broadcast(List<Serializable> messages) {
        this.getBroadcaster().broadcast(messages, this.atmResource);
    }

    @Override
    public void post(Serializable message) {
        this.getBroadcaster().broadcast((Object)message, this.atmResource);
    }

    @Override
    public void post(List<Serializable> messages) {
        this.getBroadcaster().broadcast(messages, this.atmResource);
    }

    @Override
    public AtmosphereResource<HttpServletRequest, HttpServletResponse> getAtmosphereResource() {
        return this.atmResource;
    }

    @Override
    public boolean isAlive() {
        if (this.writer.isTerminated()) {
            return false;
        }
        if (System.currentTimeMillis() - this.startTime < 10000L) {
            return true;
        }
        if (this.atmResource.getBroadcaster() == null) {
            return false;
        }
        Collection res = this.atmResource.getBroadcaster().getAtmosphereResources();
        for (AtmosphereResource ar : res) {
            if (ar != this.atmResource) continue;
            return true;
        }
        return this.suspended;
    }

    @Override
    public boolean isSystemMessage(Serializable message) {
        return HEARTBEAT_MESSAGE.equals(message);
    }

    long getStartTime() {
        return this.startTime;
    }

    @Override
    public HttpServletRequest getRequest() {
        return (HttpServletRequest)this.atmResource.getRequest();
    }

    @Override
    public HttpServletResponse getResponse() {
        return (HttpServletResponse)this.atmResource.getResponse();
    }

    @Override
    public int getConnectionID() {
        return this.writer.connectionID;
    }

    public void suspend() throws IOException {
        this.suspend(-1);
    }

    public void suspend(int timeout) throws IOException {
        if (!this.suspended) {
            this.atmResource.setSerializer(this.serializer);
            if (this.atmResource instanceof AtmosphereEventLifecycle) {
                AtmosphereResource<HttpServletRequest, HttpServletResponse> ael = this.atmResource;
                ael.addEventListener(this.eventListener);
            }
            this.writer.suspend();
            this.atmResource.suspend((long)timeout, false);
        }
    }

    public void resume() {
        this.atmResource.resume();
    }

    void resumeAfterDeath() {
        this.atmosphereHandler.execute(new Runnable(){

            @Override
            public void run() {
                GwtAtmosphereResourceImpl.this.atmResource.resume();
            }
        });
    }

    @Override
    public <T> void setAttribute(String name, T value) {
        ((HttpServletRequest)this.atmResource.getRequest()).setAttribute(name, value);
    }

    @Override
    public <T> T getAttribute(String name) {
        return (T)((HttpServletRequest)this.atmResource.getRequest()).getAttribute(name);
    }

    public GwtResponseWriterImpl getWriterImpl() {
        return this.writer;
    }

    ScheduledFuture<?> scheduleHeartbeat() {
        return this.getBroadcaster().getBroadcasterConfig().getScheduledExecutorService().schedule(this.heartBeatTask, (long)this.heartBeatInterval, TimeUnit.MILLISECONDS);
    }

    void terminate(boolean serverInitiated) {
        AtmosphereGwtHandler s = this.atmosphereHandler;
        if (s != null) {
            this.atmosphereHandler = null;
            if (this.suspended) {
                this.atmResource.resume();
            }
            s.cometTerminated(this, serverInitiated);
        }
    }

    private GwtResponseWriterImpl createResponseWriter() throws IOException {
        ClientOracle clientOracle = RPCUtil.getClientOracle((HttpServletRequest)this.atmResource.getRequest(), this.atmosphereHandler.getServletContext());
        SerializationPolicy serializationPolicy = clientOracle == null ? RPCUtil.createSimpleSerializationPolicy() : null;
        String transport = ((HttpServletRequest)this.atmResource.getRequest()).getParameter("tr");
        if ("WebSocket".equals(transport)) {
            this.logger.debug("atmosphere-gwt Using websocket");
            return new WebsocketResponseWriter(this, serializationPolicy, clientOracle);
        }
        if ("HTTPRequest".equals(transport)) {
            this.logger.debug("atmosphere-gwt Using XMLHttpRequest");
            return new HTTPRequestResponseWriter(this, serializationPolicy, clientOracle);
        }
        if ("IFrame".equals(transport)) {
            this.logger.debug("atmosphere-gwt Using streaming IFrame");
            return new IFrameResponseWriter(this, serializationPolicy, clientOracle);
        }
        if ("OperaEventSource".equals(transport)) {
            this.logger.debug("atmosphere-gwt Using Opera EventSource");
            return new OperaEventSourceResponseWriter(this, serializationPolicy, clientOracle);
        }
        if ("IEXDomainRequest".equals(transport)) {
            this.logger.debug("atmosphere-gwt Using IE XDomainRequest");
            return new IEXDomainRequestResponseWriter(this, serializationPolicy, clientOracle);
        }
        if ("IEHTMLFile".equals(transport)) {
            this.logger.debug("atmosphere-gwt Using IE html file iframe");
            return new IEHTMLFileResponseWriter(this, serializationPolicy, clientOracle);
        }
        throw new IllegalStateException("Failed to determine responsewriter");
    }
}

