/*
 * Decompiled with CFR 0.152.
 */
package iotmodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TransportLayer implements Enumerator
{
    TCP(0, "TCP", "TCP"),
    UDP(1, "UDP", "UDP"),
    ZIGBEE(2, "Zigbee", "Zigbee"),
    DTLS(3, "DTLS", "DTLS"),
    SMS(4, "SMS", "SMS");

    public static final int TCP_VALUE = 0;
    public static final int UDP_VALUE = 1;
    public static final int ZIGBEE_VALUE = 2;
    public static final int DTLS_VALUE = 3;
    public static final int SMS_VALUE = 4;
    private static final TransportLayer[] VALUES_ARRAY;
    public static final List<TransportLayer> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static TransportLayer get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            TransportLayer result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static TransportLayer getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            TransportLayer result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static TransportLayer get(int value) {
        switch (value) {
            case 0: {
                return TCP;
            }
            case 1: {
                return UDP;
            }
            case 2: {
                return ZIGBEE;
            }
            case 3: {
                return DTLS;
            }
            case 4: {
                return SMS;
            }
        }
        return null;
    }

    private TransportLayer(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new TransportLayer[]{TCP, UDP, ZIGBEE, DTLS, SMS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

