/*
 * Decompiled with CFR 0.152.
 */
package iotmodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum IdList implements Enumerator
{
    EPC(0, "EPC", "EPC"),
    UCODE(2, "Ucode", "Ucode"),
    ID_AT_URI(2, "ID_at_URI", "ID_at_URI"),
    IMEI(3, "IMEI", "IMEI"),
    OID(4, "OID", "OID"),
    URI(5, "URI", "URI"),
    DOI(6, "DOI", "DOI"),
    ISBN(7, "ISBN", "ISBN"),
    IP_ADRESS(8, "IPAdress", "IPAdress");

    public static final int EPC_VALUE = 0;
    public static final int UCODE_VALUE = 2;
    public static final int ID_AT_URI_VALUE = 2;
    public static final int IMEI_VALUE = 3;
    public static final int OID_VALUE = 4;
    public static final int URI_VALUE = 5;
    public static final int DOI_VALUE = 6;
    public static final int ISBN_VALUE = 7;
    public static final int IP_ADRESS_VALUE = 8;
    private static final IdList[] VALUES_ARRAY;
    public static final List<IdList> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static IdList get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            IdList result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static IdList getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            IdList result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static IdList get(int value) {
        switch (value) {
            case 0: {
                return EPC;
            }
            case 2: {
                return UCODE;
            }
            case 3: {
                return IMEI;
            }
            case 4: {
                return OID;
            }
            case 5: {
                return URI;
            }
            case 6: {
                return DOI;
            }
            case 7: {
                return ISBN;
            }
            case 8: {
                return IP_ADRESS;
            }
        }
        return null;
    }

    private IdList(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new IdList[]{EPC, UCODE, ID_AT_URI, IMEI, OID, URI, DOI, ISBN, IP_ADRESS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

