/**
 */
package iotmodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Network Layer</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see iotmodel.IotmodelPackage#getNetworkLayer()
 * @model
 * @generated
 */
public enum NetworkLayer implements Enumerator {
	/**
	 * The '<em><b>IPv6</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #IPV6_VALUE
	 * @generated
	 * @ordered
	 */
	IPV6(0, "IPv6", "IPv6"),

	/**
	 * The '<em><b>IPv4</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #IPV4_VALUE
	 * @generated
	 * @ordered
	 */
	IPV4(1, "IPv4", "IPv4"),

	/**
	 * The '<em><b>Zigbee</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ZIGBEE_VALUE
	 * @generated
	 * @ordered
	 */
	ZIGBEE(2, "Zigbee", "Zigbee"),

	/**
	 * The '<em><b>IPsec</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #IPSEC_VALUE
	 * @generated
	 * @ordered
	 */
	IPSEC(3, "IPsec", "IPsec"),

	/**
	 * The '<em><b>Low PAN To IPv6</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #LOW_PAN_TO_IPV6_VALUE
	 * @generated
	 * @ordered
	 */
	LOW_PAN_TO_IPV6(4, "LowPANToIPv6", "LowPANToIPv6"),

	/**
	 * The '<em><b>SMS Network</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SMS_NETWORK_VALUE
	 * @generated
	 * @ordered
	 */
	SMS_NETWORK(5, "SMS_Network", "SMS_Network");

	/**
	 * The '<em><b>IPv6</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #IPV6
	 * @model name="IPv6"
	 * @generated
	 * @ordered
	 */
	public static final int IPV6_VALUE = 0;

	/**
	 * The '<em><b>IPv4</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #IPV4
	 * @model name="IPv4"
	 * @generated
	 * @ordered
	 */
	public static final int IPV4_VALUE = 1;

	/**
	 * The '<em><b>Zigbee</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ZIGBEE
	 * @model name="Zigbee"
	 * @generated
	 * @ordered
	 */
	public static final int ZIGBEE_VALUE = 2;

	/**
	 * The '<em><b>IPsec</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #IPSEC
	 * @model name="IPsec"
	 * @generated
	 * @ordered
	 */
	public static final int IPSEC_VALUE = 3;

	/**
	 * The '<em><b>Low PAN To IPv6</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #LOW_PAN_TO_IPV6
	 * @model name="LowPANToIPv6"
	 * @generated
	 * @ordered
	 */
	public static final int LOW_PAN_TO_IPV6_VALUE = 4;

	/**
	 * The '<em><b>SMS Network</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SMS_NETWORK
	 * @model name="SMS_Network"
	 * @generated
	 * @ordered
	 */
	public static final int SMS_NETWORK_VALUE = 5;

	/**
	 * An array of all the '<em><b>Network Layer</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final NetworkLayer[] VALUES_ARRAY =
		new NetworkLayer[] {
			IPV6,
			IPV4,
			ZIGBEE,
			IPSEC,
			LOW_PAN_TO_IPV6,
			SMS_NETWORK,
		};

	/**
	 * A public read-only list of all the '<em><b>Network Layer</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<NetworkLayer> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Network Layer</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static NetworkLayer get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			NetworkLayer result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Network Layer</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static NetworkLayer getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			NetworkLayer result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Network Layer</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static NetworkLayer get(int value) {
		switch (value) {
			case IPV6_VALUE: return IPV6;
			case IPV4_VALUE: return IPV4;
			case ZIGBEE_VALUE: return ZIGBEE;
			case IPSEC_VALUE: return IPSEC;
			case LOW_PAN_TO_IPV6_VALUE: return LOW_PAN_TO_IPV6;
			case SMS_NETWORK_VALUE: return SMS_NETWORK;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private NetworkLayer(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //NetworkLayer
