/*
 * Decompiled with CFR 0.152.
 */
package iotmodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum OsList implements Enumerator
{
    CONTIKI(0, "Contiki", "Contiki"),
    TINY_OS(1, "TinyOS", "TinyOS"),
    RIOT(2, "Riot", "Riot"),
    RASPBERRY_PI(3, "RaspberryPi", "RaspberryPi"),
    FREE_RTOS(4, "FreeRTOS", "FreeRTOS"),
    LITE_OS(5, "LiteOS", "LiteOS"),
    MANTIS(6, "Mantis", "Mantis"),
    ARDUINO(7, "Arduino", "Arduino");

    public static final int CONTIKI_VALUE = 0;
    public static final int TINY_OS_VALUE = 1;
    public static final int RIOT_VALUE = 2;
    public static final int RASPBERRY_PI_VALUE = 3;
    public static final int FREE_RTOS_VALUE = 4;
    public static final int LITE_OS_VALUE = 5;
    public static final int MANTIS_VALUE = 6;
    public static final int ARDUINO_VALUE = 7;
    private static final OsList[] VALUES_ARRAY;
    public static final List<OsList> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static OsList get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            OsList result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static OsList getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            OsList result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static OsList get(int value) {
        switch (value) {
            case 0: {
                return CONTIKI;
            }
            case 1: {
                return TINY_OS;
            }
            case 2: {
                return RIOT;
            }
            case 3: {
                return RASPBERRY_PI;
            }
            case 4: {
                return FREE_RTOS;
            }
            case 5: {
                return LITE_OS;
            }
            case 6: {
                return MANTIS;
            }
            case 7: {
                return ARDUINO;
            }
        }
        return null;
    }

    private OsList(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new OsList[]{CONTIKI, TINY_OS, RIOT, RASPBERRY_PI, FREE_RTOS, LITE_OS, MANTIS, ARDUINO};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

