/*
 * Decompiled with CFR 0.152.
 */
package iotmodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum NetworkLayer implements Enumerator
{
    IPV6(0, "IPv6", "IPv6"),
    IPV4(1, "IPv4", "IPv4"),
    ZIGBEE(2, "Zigbee", "Zigbee"),
    IPSEC(3, "IPsec", "IPsec"),
    LOW_PAN_TO_IPV6(4, "LowPANToIPv6", "LowPANToIPv6"),
    SMS_NETWORK(5, "SMS_Network", "SMS_Network");

    public static final int IPV6_VALUE = 0;
    public static final int IPV4_VALUE = 1;
    public static final int ZIGBEE_VALUE = 2;
    public static final int IPSEC_VALUE = 3;
    public static final int LOW_PAN_TO_IPV6_VALUE = 4;
    public static final int SMS_NETWORK_VALUE = 5;
    private static final NetworkLayer[] VALUES_ARRAY;
    public static final List<NetworkLayer> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static NetworkLayer get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            NetworkLayer result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static NetworkLayer getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            NetworkLayer result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static NetworkLayer get(int value) {
        switch (value) {
            case 0: {
                return IPV6;
            }
            case 1: {
                return IPV4;
            }
            case 2: {
                return ZIGBEE;
            }
            case 3: {
                return IPSEC;
            }
            case 4: {
                return LOW_PAN_TO_IPV6;
            }
            case 5: {
                return SMS_NETWORK;
            }
        }
        return null;
    }

    private NetworkLayer(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new NetworkLayer[]{IPV6, IPV4, ZIGBEE, IPSEC, LOW_PAN_TO_IPV6, SMS_NETWORK};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

