/**
 */
package iotmodel.impl;

import iotmodel.AccessControlPolicy;
import iotmodel.IotmodelPackage;
import iotmodel.Network;
import iotmodel.Rule;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Access Control Policy</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link iotmodel.impl.AccessControlPolicyImpl#getRule <em>Rule</em>}</li>
 *   <li>{@link iotmodel.impl.AccessControlPolicyImpl#getIsEnforced <em>Is Enforced</em>}</li>
 *   <li>{@link iotmodel.impl.AccessControlPolicyImpl#getPolicyName <em>Policy Name</em>}</li>
 * </ul>
 *
 * @generated
 */
public abstract class AccessControlPolicyImpl extends MinimalEObjectImpl.Container implements AccessControlPolicy {
	/**
	 * The cached value of the '{@link #getRule() <em>Rule</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRule()
	 * @generated
	 * @ordered
	 */
	protected EList<Rule> rule;

	/**
	 * The cached value of the '{@link #getIsEnforced() <em>Is Enforced</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIsEnforced()
	 * @generated
	 * @ordered
	 */
	protected EList<Network> isEnforced;

	/**
	 * The default value of the '{@link #getPolicyName() <em>Policy Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPolicyName()
	 * @generated
	 * @ordered
	 */
	protected static final String POLICY_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getPolicyName() <em>Policy Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPolicyName()
	 * @generated
	 * @ordered
	 */
	protected String policyName = POLICY_NAME_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AccessControlPolicyImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return IotmodelPackage.Literals.ACCESS_CONTROL_POLICY;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Rule> getRule() {
		if (rule == null) {
			rule = new EObjectContainmentEList<Rule>(Rule.class, this, IotmodelPackage.ACCESS_CONTROL_POLICY__RULE);
		}
		return rule;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Network> getIsEnforced() {
		if (isEnforced == null) {
			isEnforced = new EObjectWithInverseResolvingEList.ManyInverse<Network>(Network.class, this, IotmodelPackage.ACCESS_CONTROL_POLICY__IS_ENFORCED, IotmodelPackage.NETWORK__ENFORCE);
		}
		return isEnforced;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getPolicyName() {
		return policyName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPolicyName(String newPolicyName) {
		String oldPolicyName = policyName;
		policyName = newPolicyName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IotmodelPackage.ACCESS_CONTROL_POLICY__POLICY_NAME, oldPolicyName, policyName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case IotmodelPackage.ACCESS_CONTROL_POLICY__IS_ENFORCED:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getIsEnforced()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case IotmodelPackage.ACCESS_CONTROL_POLICY__RULE:
				return ((InternalEList<?>)getRule()).basicRemove(otherEnd, msgs);
			case IotmodelPackage.ACCESS_CONTROL_POLICY__IS_ENFORCED:
				return ((InternalEList<?>)getIsEnforced()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case IotmodelPackage.ACCESS_CONTROL_POLICY__RULE:
				return getRule();
			case IotmodelPackage.ACCESS_CONTROL_POLICY__IS_ENFORCED:
				return getIsEnforced();
			case IotmodelPackage.ACCESS_CONTROL_POLICY__POLICY_NAME:
				return getPolicyName();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case IotmodelPackage.ACCESS_CONTROL_POLICY__RULE:
				getRule().clear();
				getRule().addAll((Collection<? extends Rule>)newValue);
				return;
			case IotmodelPackage.ACCESS_CONTROL_POLICY__IS_ENFORCED:
				getIsEnforced().clear();
				getIsEnforced().addAll((Collection<? extends Network>)newValue);
				return;
			case IotmodelPackage.ACCESS_CONTROL_POLICY__POLICY_NAME:
				setPolicyName((String)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case IotmodelPackage.ACCESS_CONTROL_POLICY__RULE:
				getRule().clear();
				return;
			case IotmodelPackage.ACCESS_CONTROL_POLICY__IS_ENFORCED:
				getIsEnforced().clear();
				return;
			case IotmodelPackage.ACCESS_CONTROL_POLICY__POLICY_NAME:
				setPolicyName(POLICY_NAME_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case IotmodelPackage.ACCESS_CONTROL_POLICY__RULE:
				return rule != null && !rule.isEmpty();
			case IotmodelPackage.ACCESS_CONTROL_POLICY__IS_ENFORCED:
				return isEnforced != null && !isEnforced.isEmpty();
			case IotmodelPackage.ACCESS_CONTROL_POLICY__POLICY_NAME:
				return POLICY_NAME_EDEFAULT == null ? policyName != null : !POLICY_NAME_EDEFAULT.equals(policyName);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (policyName: ");
		result.append(policyName);
		result.append(')');
		return result.toString();
	}

} //AccessControlPolicyImpl
