/**
 */
package iotmodel.impl;

import iotmodel.*;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class IotmodelFactoryImpl extends EFactoryImpl implements IotmodelFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static IotmodelFactory init() {
		try {
			IotmodelFactory theIotmodelFactory = (IotmodelFactory)EPackage.Registry.INSTANCE.getEFactory(IotmodelPackage.eNS_URI);
			if (theIotmodelFactory != null) {
				return theIotmodelFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new IotmodelFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IotmodelFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case IotmodelPackage.GATEWAY: return createGateway();
			case IotmodelPackage.NETWORK: return createNetwork();
			case IotmodelPackage.REQUEST_RESPONSE: return createRequestResponse();
			case IotmodelPackage.PUBLISH_SUBSCRIBE: return createPublishSubscribe();
			case IotmodelPackage.PROTOCOL_STACK: return createProtocolStack();
			case IotmodelPackage.RULE: return createRule();
			case IotmodelPackage.IO_TOS: return createIoTOs();
			case IotmodelPackage.IO_TPLATFORM: return createIoTPlatform();
			case IotmodelPackage.MESSAGE_FORMAT: return createMessageFormat();
			case IotmodelPackage.MESSAGE_BROKER: return createMessageBroker();
			case IotmodelPackage.TOPIC: return createTopic();
			case IotmodelPackage.DESKTOP_APP: return createDesktopApp();
			case IotmodelPackage.MOBILE_APP: return createMobileApp();
			case IotmodelPackage.WEB_SERVER: return createWebServer();
			case IotmodelPackage.DEFAULT_POLICY: return createDefaultPolicy();
			case IotmodelPackage.PRIVATE_POLICY: return createPrivatePolicy();
			case IotmodelPackage.CONSTRAINT_EXPRESSION: return createConstraintExpression();
			case IotmodelPackage.ALLOW_PERMISSION: return createAllowPermission();
			case IotmodelPackage.DENY_PERMISSION: return createDenyPermission();
			case IotmodelPackage.SENSOR: return createSensor();
			case IotmodelPackage.ACTUATOR: return createActuator();
			case IotmodelPackage.IO_TMETAMODEL: return createIoTMetamodel();
			case IotmodelPackage.ID: return createID();
			case IotmodelPackage.BEHAVIOR: return createBehavior();
			case IotmodelPackage.ACTION: return createAction();
			case IotmodelPackage.EVENT: return createEvent();
			case IotmodelPackage.PROGRAMMING_MODEL: return createProgrammingModel();
			case IotmodelPackage.SHARED_ACTION: return createSharedAction();
			case IotmodelPackage.APP_PORT: return createAppPort();
			case IotmodelPackage.DATA: return createData();
			case IotmodelPackage.ACTOR: return createActor();
			case IotmodelPackage.MALICIOUS_ACTOR: return createMaliciousActor();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case IotmodelPackage.OS_LIST:
				return createOsListFromString(eDataType, initialValue);
			case IotmodelPackage.PHYSICAL_LINK_LAYER:
				return createPhysicalLinkLayerFromString(eDataType, initialValue);
			case IotmodelPackage.TRANSPORT_LAYER:
				return createTransportLayerFromString(eDataType, initialValue);
			case IotmodelPackage.NETWORK_LAYER:
				return createNetworkLayerFromString(eDataType, initialValue);
			case IotmodelPackage.APPLICATION_LAYER:
				return createApplicationLayerFromString(eDataType, initialValue);
			case IotmodelPackage.ID_LIST:
				return createIdListFromString(eDataType, initialValue);
			case IotmodelPackage.LANGUAGE_LIST:
				return createLanguageListFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case IotmodelPackage.OS_LIST:
				return convertOsListToString(eDataType, instanceValue);
			case IotmodelPackage.PHYSICAL_LINK_LAYER:
				return convertPhysicalLinkLayerToString(eDataType, instanceValue);
			case IotmodelPackage.TRANSPORT_LAYER:
				return convertTransportLayerToString(eDataType, instanceValue);
			case IotmodelPackage.NETWORK_LAYER:
				return convertNetworkLayerToString(eDataType, instanceValue);
			case IotmodelPackage.APPLICATION_LAYER:
				return convertApplicationLayerToString(eDataType, instanceValue);
			case IotmodelPackage.ID_LIST:
				return convertIdListToString(eDataType, instanceValue);
			case IotmodelPackage.LANGUAGE_LIST:
				return convertLanguageListToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Gateway createGateway() {
		GatewayImpl gateway = new GatewayImpl();
		return gateway;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Network createNetwork() {
		NetworkImpl network = new NetworkImpl();
		return network;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RequestResponse createRequestResponse() {
		RequestResponseImpl requestResponse = new RequestResponseImpl();
		return requestResponse;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PublishSubscribe createPublishSubscribe() {
		PublishSubscribeImpl publishSubscribe = new PublishSubscribeImpl();
		return publishSubscribe;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProtocolStack createProtocolStack() {
		ProtocolStackImpl protocolStack = new ProtocolStackImpl();
		return protocolStack;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Rule createRule() {
		RuleImpl rule = new RuleImpl();
		return rule;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IoTOs createIoTOs() {
		IoTOsImpl ioTOs = new IoTOsImpl();
		return ioTOs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IoTPlatform createIoTPlatform() {
		IoTPlatformImpl ioTPlatform = new IoTPlatformImpl();
		return ioTPlatform;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MessageFormat createMessageFormat() {
		MessageFormatImpl messageFormat = new MessageFormatImpl();
		return messageFormat;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MessageBroker createMessageBroker() {
		MessageBrokerImpl messageBroker = new MessageBrokerImpl();
		return messageBroker;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Topic createTopic() {
		TopicImpl topic = new TopicImpl();
		return topic;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DesktopApp createDesktopApp() {
		DesktopAppImpl desktopApp = new DesktopAppImpl();
		return desktopApp;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MobileApp createMobileApp() {
		MobileAppImpl mobileApp = new MobileAppImpl();
		return mobileApp;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public WebServer createWebServer() {
		WebServerImpl webServer = new WebServerImpl();
		return webServer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DefaultPolicy createDefaultPolicy() {
		DefaultPolicyImpl defaultPolicy = new DefaultPolicyImpl();
		return defaultPolicy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PrivatePolicy createPrivatePolicy() {
		PrivatePolicyImpl privatePolicy = new PrivatePolicyImpl();
		return privatePolicy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ConstraintExpression createConstraintExpression() {
		ConstraintExpressionImpl constraintExpression = new ConstraintExpressionImpl();
		return constraintExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AllowPermission createAllowPermission() {
		AllowPermissionImpl allowPermission = new AllowPermissionImpl();
		return allowPermission;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DenyPermission createDenyPermission() {
		DenyPermissionImpl denyPermission = new DenyPermissionImpl();
		return denyPermission;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Sensor createSensor() {
		SensorImpl sensor = new SensorImpl();
		return sensor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Actuator createActuator() {
		ActuatorImpl actuator = new ActuatorImpl();
		return actuator;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IoTMetamodel createIoTMetamodel() {
		IoTMetamodelImpl ioTMetamodel = new IoTMetamodelImpl();
		return ioTMetamodel;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ID createID() {
		IDImpl id = new IDImpl();
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Behavior createBehavior() {
		BehaviorImpl behavior = new BehaviorImpl();
		return behavior;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Action createAction() {
		ActionImpl action = new ActionImpl();
		return action;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Event createEvent() {
		EventImpl event = new EventImpl();
		return event;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProgrammingModel createProgrammingModel() {
		ProgrammingModelImpl programmingModel = new ProgrammingModelImpl();
		return programmingModel;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SharedAction createSharedAction() {
		SharedActionImpl sharedAction = new SharedActionImpl();
		return sharedAction;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AppPort createAppPort() {
		AppPortImpl appPort = new AppPortImpl();
		return appPort;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Data createData() {
		DataImpl data = new DataImpl();
		return data;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Actor createActor() {
		ActorImpl actor = new ActorImpl();
		return actor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MaliciousActor createMaliciousActor() {
		MaliciousActorImpl maliciousActor = new MaliciousActorImpl();
		return maliciousActor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OsList createOsListFromString(EDataType eDataType, String initialValue) {
		OsList result = OsList.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertOsListToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PhysicalLinkLayer createPhysicalLinkLayerFromString(EDataType eDataType, String initialValue) {
		PhysicalLinkLayer result = PhysicalLinkLayer.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertPhysicalLinkLayerToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TransportLayer createTransportLayerFromString(EDataType eDataType, String initialValue) {
		TransportLayer result = TransportLayer.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertTransportLayerToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NetworkLayer createNetworkLayerFromString(EDataType eDataType, String initialValue) {
		NetworkLayer result = NetworkLayer.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertNetworkLayerToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ApplicationLayer createApplicationLayerFromString(EDataType eDataType, String initialValue) {
		ApplicationLayer result = ApplicationLayer.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertApplicationLayerToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IdList createIdListFromString(EDataType eDataType, String initialValue) {
		IdList result = IdList.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertIdListToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LanguageList createLanguageListFromString(EDataType eDataType, String initialValue) {
		LanguageList result = LanguageList.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertLanguageListToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IotmodelPackage getIotmodelPackage() {
		return (IotmodelPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static IotmodelPackage getPackage() {
		return IotmodelPackage.eINSTANCE;
	}

} //IotmodelFactoryImpl
