/**
 */
package iotmodel;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Io TPlatform</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link iotmodel.IoTPlatform#getUseProtocol <em>Use Protocol</em>}</li>
 *   <li>{@link iotmodel.IoTPlatform#getSentReceivedByPlatform <em>Sent Received By Platform</em>}</li>
 *   <li>{@link iotmodel.IoTPlatform#getCommunicateThrough <em>Communicate Through</em>}</li>
 *   <li>{@link iotmodel.IoTPlatform#getUserapplication <em>Userapplication</em>}</li>
 *   <li>{@link iotmodel.IoTPlatform#getMessagebroker <em>Messagebroker</em>}</li>
 *   <li>{@link iotmodel.IoTPlatform#getWebserver <em>Webserver</em>}</li>
 * </ul>
 *
 * @see iotmodel.IotmodelPackage#getIoTPlatform()
 * @model
 * @generated
 */
public interface IoTPlatform extends EObject {
	/**
	 * Returns the value of the '<em><b>Use Protocol</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Use Protocol</em>' reference.
	 * @see #setUseProtocol(ProtocolStack)
	 * @see iotmodel.IotmodelPackage#getIoTPlatform_UseProtocol()
	 * @model
	 * @generated
	 */
	ProtocolStack getUseProtocol();

	/**
	 * Sets the value of the '{@link iotmodel.IoTPlatform#getUseProtocol <em>Use Protocol</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Use Protocol</em>' reference.
	 * @see #getUseProtocol()
	 * @generated
	 */
	void setUseProtocol(ProtocolStack value);

	/**
	 * Returns the value of the '<em><b>Sent Received By Platform</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link iotmodel.Message#getSendReceiveMessage <em>Send Receive Message</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Sent Received By Platform</em>' reference.
	 * @see #setSentReceivedByPlatform(Message)
	 * @see iotmodel.IotmodelPackage#getIoTPlatform_SentReceivedByPlatform()
	 * @see iotmodel.Message#getSendReceiveMessage
	 * @model opposite="sendReceiveMessage"
	 * @generated
	 */
	Message getSentReceivedByPlatform();

	/**
	 * Sets the value of the '{@link iotmodel.IoTPlatform#getSentReceivedByPlatform <em>Sent Received By Platform</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Sent Received By Platform</em>' reference.
	 * @see #getSentReceivedByPlatform()
	 * @generated
	 */
	void setSentReceivedByPlatform(Message value);

	/**
	 * Returns the value of the '<em><b>Communicate Through</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Communicate Through</em>' reference.
	 * @see #setCommunicateThrough(AppChannel)
	 * @see iotmodel.IotmodelPackage#getIoTPlatform_CommunicateThrough()
	 * @model
	 * @generated
	 */
	AppChannel getCommunicateThrough();

	/**
	 * Sets the value of the '{@link iotmodel.IoTPlatform#getCommunicateThrough <em>Communicate Through</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Communicate Through</em>' reference.
	 * @see #getCommunicateThrough()
	 * @generated
	 */
	void setCommunicateThrough(AppChannel value);

	/**
	 * Returns the value of the '<em><b>Userapplication</b></em>' reference list.
	 * The list contents are of type {@link iotmodel.UserApplication}.
	 * It is bidirectional and its opposite is '{@link iotmodel.UserApplication#getIotplatform <em>Iotplatform</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Userapplication</em>' reference list.
	 * @see iotmodel.IotmodelPackage#getIoTPlatform_Userapplication()
	 * @see iotmodel.UserApplication#getIotplatform
	 * @model opposite="iotplatform"
	 * @generated
	 */
	EList<UserApplication> getUserapplication();

	/**
	 * Returns the value of the '<em><b>Messagebroker</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link iotmodel.MessageBroker#getIotplatform <em>Iotplatform</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Messagebroker</em>' reference.
	 * @see #setMessagebroker(MessageBroker)
	 * @see iotmodel.IotmodelPackage#getIoTPlatform_Messagebroker()
	 * @see iotmodel.MessageBroker#getIotplatform
	 * @model opposite="iotplatform"
	 * @generated
	 */
	MessageBroker getMessagebroker();

	/**
	 * Sets the value of the '{@link iotmodel.IoTPlatform#getMessagebroker <em>Messagebroker</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Messagebroker</em>' reference.
	 * @see #getMessagebroker()
	 * @generated
	 */
	void setMessagebroker(MessageBroker value);

	/**
	 * Returns the value of the '<em><b>Webserver</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link iotmodel.WebServer#getIotplatform <em>Iotplatform</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Webserver</em>' reference.
	 * @see #setWebserver(WebServer)
	 * @see iotmodel.IotmodelPackage#getIoTPlatform_Webserver()
	 * @see iotmodel.WebServer#getIotplatform
	 * @model opposite="iotplatform"
	 * @generated
	 */
	WebServer getWebserver();

	/**
	 * Sets the value of the '{@link iotmodel.IoTPlatform#getWebserver <em>Webserver</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Webserver</em>' reference.
	 * @see #getWebserver()
	 * @generated
	 */
	void setWebserver(WebServer value);

} // IoTPlatform
