/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.request.body;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.request.ProgressListener;
import org.asynchttpclient.netty.request.body.BodyChunkedInput;
import org.asynchttpclient.netty.request.body.NettyBody;
import org.asynchttpclient.request.body.Body;
import org.asynchttpclient.request.body.generator.InputStreamBodyGenerator;
import org.asynchttpclient.util.MiscUtils;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyInputStreamBody
implements NettyBody {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyInputStreamBody.class);
    private final InputStream inputStream;
    private final AsyncHttpClientConfig config;

    public NettyInputStreamBody(InputStream inputStream, AsyncHttpClientConfig config) {
        this.inputStream = inputStream;
        this.config = config;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public String getContentType() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void write(Channel channel, NettyResponseFuture<?> future) throws IOException {
        InputStream is = this.inputStream;
        if (future.isStreamWasAlreadyConsumed()) {
            if (!is.markSupported()) {
                LOGGER.warn("Stream has already been consumed and cannot be reset");
                return;
            }
            is.reset();
        } else {
            future.setStreamWasAlreadyConsumed(true);
        }
        InputStreamBodyGenerator generator = new InputStreamBodyGenerator(is);
        generator.patchNetty3ChunkingIssue(true);
        final Body body = generator.createBody();
        channel.write((Object)new BodyChunkedInput(body)).addListener((ChannelFutureListener)new ProgressListener(this.config, future.getAsyncHandler(), future, false){

            @Override
            public void operationComplete(ChannelFuture cf) {
                MiscUtils.closeSilently((Closeable)body);
                super.operationComplete(cf);
            }
        });
    }
}

