/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.request.body;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.channel.ChannelManager;
import org.asynchttpclient.netty.request.ProgressListener;
import org.asynchttpclient.netty.request.body.NettyBody;
import org.asynchttpclient.netty.request.body.OptimizedFileRegion;
import org.asynchttpclient.util.MiscUtils;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.stream.ChunkedFile;

public class NettyFileBody
implements NettyBody {
    private final File file;
    private final long offset;
    private final long length;
    private final AsyncHttpClientConfig config;

    public NettyFileBody(File file, AsyncHttpClientConfig config) {
        this(file, 0L, file.length(), config);
    }

    public NettyFileBody(File file, long offset, long length, AsyncHttpClientConfig config) {
        if (!file.isFile()) {
            throw new IllegalArgumentException(String.format("File %s is not a file or doesn't exist", file.getAbsolutePath()));
        }
        this.file = file;
        this.offset = offset;
        this.length = length;
        this.config = config;
    }

    public File getFile() {
        return this.file;
    }

    public long getOffset() {
        return this.offset;
    }

    @Override
    public long getContentLength() {
        return this.length;
    }

    @Override
    public String getContentType() {
        return null;
    }

    @Override
    public void write(Channel channel, NettyResponseFuture<?> future) throws IOException {
        final RandomAccessFile raf = new RandomAccessFile(this.file, "r");
        try {
            ChannelFuture writeFuture;
            if (ChannelManager.isSslHandlerConfigured(channel.getPipeline()) || this.config.isDisableZeroCopy()) {
                writeFuture = channel.write((Object)new ChunkedFile(raf, this.offset, raf.length(), this.config.getChunkedFileChunkSize()));
            } else {
                OptimizedFileRegion region = new OptimizedFileRegion(raf, this.offset, raf.length());
                writeFuture = channel.write((Object)region);
            }
            writeFuture.addListener((ChannelFutureListener)new ProgressListener(this.config, future.getAsyncHandler(), future, false){

                @Override
                public void operationComplete(ChannelFuture cf) {
                    MiscUtils.closeSilently((Closeable)raf);
                    super.operationComplete(cf);
                }
            });
        }
        catch (IOException ex) {
            MiscUtils.closeSilently((Closeable)raf);
            throw ex;
        }
    }
}

