/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.request.body;

import java.io.Closeable;
import java.io.IOException;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.channel.ChannelManager;
import org.asynchttpclient.netty.request.ProgressListener;
import org.asynchttpclient.netty.request.body.BodyChunkedInput;
import org.asynchttpclient.netty.request.body.BodyFileRegion;
import org.asynchttpclient.netty.request.body.NettyBody;
import org.asynchttpclient.request.body.Body;
import org.asynchttpclient.request.body.RandomAccessBody;
import org.asynchttpclient.request.body.generator.BodyGenerator;
import org.asynchttpclient.request.body.generator.FeedableBodyGenerator;
import org.asynchttpclient.util.MiscUtils;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;

public class NettyBodyBody
implements NettyBody {
    private final Body body;
    private final AsyncHttpClientConfig config;

    public NettyBodyBody(Body body, AsyncHttpClientConfig config) {
        this.body = body;
        this.config = config;
    }

    public Body getBody() {
        return this.body;
    }

    @Override
    public long getContentLength() {
        return this.body.getContentLength();
    }

    @Override
    public String getContentType() {
        return null;
    }

    @Override
    public void write(final Channel channel, final NettyResponseFuture<?> future) throws IOException {
        Object msg;
        if (this.body instanceof RandomAccessBody && !ChannelManager.isSslHandlerConfigured(channel.getPipeline()) && !this.config.isDisableZeroCopy()) {
            msg = new BodyFileRegion((RandomAccessBody)this.body);
        } else {
            msg = new BodyChunkedInput(this.body);
            BodyGenerator bg = future.getRequest().getBodyGenerator();
            if (bg instanceof FeedableBodyGenerator) {
                FeedableBodyGenerator feedableBodyGenerator = (FeedableBodyGenerator)bg;
                feedableBodyGenerator.writeChunkBoundaries();
                feedableBodyGenerator.setListener(new FeedableBodyGenerator.FeedListener(){

                    public void onContentAdded() {
                        ((ChunkedWriteHandler)channel.getPipeline().get(ChunkedWriteHandler.class)).resumeTransfer();
                    }

                    public void onError(Throwable t) {
                        future.abort(t);
                    }
                });
            }
        }
        channel.write(msg).addListener((ChannelFutureListener)new ProgressListener(this.config, future.getAsyncHandler(), future, false){

            @Override
            public void operationComplete(ChannelFuture cf) {
                MiscUtils.closeSilently((Closeable)NettyBodyBody.this.body);
                super.operationComplete(cf);
            }
        });
    }
}

