/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.request;

import java.nio.channels.ClosedChannelException;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.Realm;
import org.asynchttpclient.handler.ProgressAsyncHandler;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.channel.Channels;
import org.asynchttpclient.netty.future.StackTraceInspector;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureProgressListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressListener
implements ChannelFutureProgressListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProgressListener.class);
    private final AsyncHttpClientConfig config;
    private final boolean notifyHeaders;
    private final AsyncHandler<?> asyncHandler;
    private final NettyResponseFuture<?> future;

    public ProgressListener(AsyncHttpClientConfig config, AsyncHandler<?> asyncHandler, NettyResponseFuture<?> future, boolean notifyHeaders) {
        this.config = config;
        this.asyncHandler = asyncHandler;
        this.future = future;
        this.notifyHeaders = notifyHeaders;
    }

    private boolean abortOnThrowable(Throwable cause, Channel channel) {
        if (cause != null && this.future.getState() != NettyResponseFuture.STATE.NEW) {
            if (cause instanceof IllegalStateException || cause instanceof ClosedChannelException || StackTraceInspector.recoverOnReadOrWriteException((Throwable)cause)) {
                LOGGER.debug(cause == null ? "" : cause.getMessage(), cause);
                Channels.silentlyCloseChannel(channel);
            } else {
                this.future.abort(cause);
            }
            return true;
        }
        return false;
    }

    public void operationComplete(ChannelFuture cf) {
        if (!this.abortOnThrowable(cf.getCause(), cf.getChannel())) {
            boolean startPublishing;
            this.future.touch();
            Realm realm = this.future.getRequest().getRealm() != null ? this.future.getRequest().getRealm() : this.config.getRealm();
            boolean bl = startPublishing = this.future.isInAuth() || realm == null || realm.getUsePreemptiveAuth();
            if (startPublishing && this.asyncHandler instanceof ProgressAsyncHandler) {
                if (this.notifyHeaders) {
                    ((ProgressAsyncHandler)ProgressAsyncHandler.class.cast(this.asyncHandler)).onHeadersWritten();
                } else {
                    ((ProgressAsyncHandler)ProgressAsyncHandler.class.cast(this.asyncHandler)).onContentWritten();
                }
            }
        }
    }

    public void operationProgressed(ChannelFuture cf, long amount, long current, long total) {
        this.future.touch();
        if (this.asyncHandler instanceof ProgressAsyncHandler) {
            ((ProgressAsyncHandler)ProgressAsyncHandler.class.cast(this.asyncHandler)).onContentWriteProgress(amount, current, total);
        }
    }
}

