/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.request;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.FluentCaseInsensitiveStringsMap;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Request;
import org.asynchttpclient.filter.FilterContext;
import org.asynchttpclient.filter.FilterException;
import org.asynchttpclient.filter.IOExceptionFilter;
import org.asynchttpclient.handler.AsyncHandlerExtensions;
import org.asynchttpclient.handler.TransferCompletionHandler;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.channel.ChannelManager;
import org.asynchttpclient.netty.channel.Channels;
import org.asynchttpclient.netty.channel.NettyConnectListener;
import org.asynchttpclient.netty.request.NettyChannelConnector;
import org.asynchttpclient.netty.request.NettyRequest;
import org.asynchttpclient.netty.request.NettyRequestFactory;
import org.asynchttpclient.netty.request.ProgressListener;
import org.asynchttpclient.netty.timeout.ReadTimeoutTimerTask;
import org.asynchttpclient.netty.timeout.RequestTimeoutTimerTask;
import org.asynchttpclient.netty.timeout.TimeoutsHolder;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.AsyncHttpProviderUtils;
import org.asynchttpclient.util.AuthenticatorUtils;
import org.asynchttpclient.util.HttpUtils;
import org.asynchttpclient.util.ProxyUtils;
import org.asynchttpclient.ws.WebSocketUpgradeHandler;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyRequestSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyRequestSender.class);
    private final AsyncHttpClientConfig config;
    private final ChannelManager channelManager;
    private final Timer nettyTimer;
    private final AtomicBoolean closed;
    private final NettyRequestFactory requestFactory;

    public NettyRequestSender(AsyncHttpClientConfig config, ChannelManager channelManager, Timer nettyTimer, AtomicBoolean closed) {
        this.config = config;
        this.channelManager = channelManager;
        this.nettyTimer = nettyTimer;
        this.closed = closed;
        this.requestFactory = new NettyRequestFactory(config);
    }

    public <T> ListenableFuture<T> sendRequest(Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> future, boolean reclaimCache) {
        boolean useProxy;
        if (this.closed.get()) {
            throw new IllegalStateException("Closed");
        }
        this.validateWebSocketRequest(request, asyncHandler);
        ProxyServer proxyServer = ProxyUtils.getProxyServer((AsyncHttpClientConfig)this.config, (Request)request);
        boolean resultOfAConnect = future != null && future.getNettyRequest() != null && future.getNettyRequest().getHttpRequest().getMethod() == HttpMethod.CONNECT;
        boolean bl = useProxy = proxyServer != null && !resultOfAConnect;
        if (useProxy && HttpUtils.useProxyConnect((Uri)request.getUri())) {
            if (future != null && future.isConnectAllowed()) {
                return this.sendRequestWithCertainForceConnect(request, asyncHandler, future, reclaimCache, proxyServer, true, true);
            }
            return this.sendRequestThroughSslProxy(request, asyncHandler, future, reclaimCache, proxyServer);
        }
        return this.sendRequestWithCertainForceConnect(request, asyncHandler, future, reclaimCache, proxyServer, useProxy, false);
    }

    private <T> ListenableFuture<T> sendRequestWithCertainForceConnect(Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> future, boolean reclaimCache, ProxyServer proxyServer, boolean useProxy, boolean forceConnect) {
        NettyResponseFuture<T> newFuture = this.newNettyRequestAndResponseFuture(request, asyncHandler, future, proxyServer, forceConnect);
        Channel channel = this.getCachedChannel(future, request, proxyServer, asyncHandler);
        if (Channels.isChannelValid(channel)) {
            return this.sendRequestWithCachedChannel(request, proxyServer, newFuture, asyncHandler, channel);
        }
        return this.sendRequestWithNewChannel(request, proxyServer, useProxy, newFuture, asyncHandler, reclaimCache);
    }

    private <T> ListenableFuture<T> sendRequestThroughSslProxy(Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> future, boolean reclaimCache, ProxyServer proxyServer) {
        NettyResponseFuture<T> newFuture = null;
        int i = 0;
        if (i < 3) {
            Channel channel = this.getCachedChannel(future, request, proxyServer, asyncHandler);
            if (Channels.isChannelValid(channel) && newFuture == null) {
                newFuture = this.newNettyRequestAndResponseFuture(request, asyncHandler, future, proxyServer, false);
            }
            if (Channels.isChannelValid(channel)) {
                return this.sendRequestWithCachedChannel(request, proxyServer, newFuture, asyncHandler, channel);
            }
        }
        newFuture = this.newNettyRequestAndResponseFuture(request, asyncHandler, future, proxyServer, true);
        return this.sendRequestWithNewChannel(request, proxyServer, true, newFuture, asyncHandler, reclaimCache);
    }

    private <T> NettyResponseFuture<T> newNettyRequestAndResponseFuture(Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> originalFuture, ProxyServer proxy, boolean forceConnect) {
        NettyRequest nettyRequest = this.requestFactory.newNettyRequest(request, forceConnect, proxy);
        if (originalFuture == null) {
            return this.newNettyResponseFuture(request, asyncHandler, nettyRequest, proxy);
        }
        originalFuture.setNettyRequest(nettyRequest);
        originalFuture.setRequest(request);
        return originalFuture;
    }

    private Channel getCachedChannel(NettyResponseFuture<?> future, Request request, ProxyServer proxyServer, AsyncHandler<?> asyncHandler) {
        if (future != null && future.reuseChannel() && Channels.isChannelValid(future.channel())) {
            return future.channel();
        }
        return this.pollAndVerifyCachedChannel(request, proxyServer, asyncHandler);
    }

    private <T> ListenableFuture<T> sendRequestWithCachedChannel(Request request, ProxyServer proxy, NettyResponseFuture<T> future, AsyncHandler<T> asyncHandler, Channel channel) {
        if (asyncHandler instanceof AsyncHandlerExtensions) {
            ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(asyncHandler)).onConnectionPooled((Object)channel);
        }
        future.setState(NettyResponseFuture.STATE.POOLED);
        future.attachChannel(channel, false);
        LOGGER.debug("Using cached Channel {} for {} '{}'", new Object[]{channel, future.getNettyRequest().getHttpRequest().getMethod(), future.getNettyRequest().getHttpRequest().getUri()});
        if (Channels.isChannelValid(channel)) {
            Channels.setAttribute(channel, future);
            this.writeRequest(future, channel);
        } else {
            this.handleUnexpectedClosedChannel(channel, future);
        }
        return future;
    }

    private <T> ListenableFuture<T> sendRequestWithNewChannel(Request request, ProxyServer proxy, boolean useProxy, NettyResponseFuture<T> future, AsyncHandler<T> asyncHandler, boolean reclaimCache) {
        HttpHeaders headers = future.getNettyRequest().getHttpRequest().headers();
        Realm realm = request.getRealm() != null ? request.getRealm() : this.config.getRealm();
        boolean connect = future.getNettyRequest().getHttpRequest().getMethod() == HttpMethod.CONNECT;
        this.requestFactory.addAuthorizationHeader(headers, AuthenticatorUtils.perConnectionAuthorizationHeader((Request)request, (ProxyServer)proxy, (Realm)realm));
        this.requestFactory.setProxyAuthorizationHeader(headers, AuthenticatorUtils.perConnectionProxyAuthorizationHeader((Request)request, (ProxyServer)proxy, (boolean)connect));
        ClientBootstrap bootstrap = this.channelManager.getBootstrap(request.getUri().getScheme(), useProxy);
        boolean channelPreempted = false;
        Object partitionKey = future.getPartitionKey();
        try {
            if (!reclaimCache) {
                this.channelManager.preemptChannel(partitionKey);
                channelPreempted = true;
            }
            if (asyncHandler instanceof AsyncHandlerExtensions) {
                ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(asyncHandler)).onConnectionOpen();
            }
            new NettyChannelConnector(request, proxy, useProxy, asyncHandler).connect(bootstrap, new NettyConnectListener<T>(future, this, this.channelManager, channelPreempted, partitionKey));
        }
        catch (Throwable t) {
            if (channelPreempted) {
                this.channelManager.abortChannelPreemption(partitionKey);
            }
            this.abort(null, future, t.getCause() == null ? t : t.getCause());
        }
        return future;
    }

    private <T> NettyResponseFuture<T> newNettyResponseFuture(Request request, AsyncHandler<T> asyncHandler, NettyRequest nettyRequest, ProxyServer proxyServer) {
        NettyResponseFuture<T> future = new NettyResponseFuture<T>(request, asyncHandler, nettyRequest, this.config.getMaxRequestRetry(), request.getConnectionPoolPartitioning(), proxyServer);
        String expectHeader = request.getHeaders().getFirstValue("Expect");
        if (expectHeader != null && expectHeader.equalsIgnoreCase("100-continue")) {
            future.setDontWriteBodyBecauseExpectContinue(true);
        }
        return future;
    }

    public <T> void writeRequest(NettyResponseFuture<T> future, Channel channel) {
        NettyRequest nettyRequest = future.getNettyRequest();
        HttpRequest httpRequest = nettyRequest.getHttpRequest();
        AsyncHandler<T> handler = future.getAsyncHandler();
        if (!Channels.isChannelValid(channel)) {
            return;
        }
        try {
            if (handler instanceof TransferCompletionHandler) {
                this.configureTransferAdapter(handler, httpRequest);
            }
            if (!future.isHeadersAlreadyWrittenOnContinue()) {
                if (future.getAsyncHandler() instanceof AsyncHandlerExtensions) {
                    ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(future.getAsyncHandler())).onRequestSend((Object)nettyRequest);
                }
                channel.write((Object)httpRequest).addListener((ChannelFutureListener)new ProgressListener(this.config, future.getAsyncHandler(), future, true));
            }
            if (!future.isDontWriteBodyBecauseExpectContinue() && httpRequest.getMethod() != HttpMethod.CONNECT && nettyRequest.getBody() != null) {
                nettyRequest.getBody().write(channel, future);
            }
            if (Channels.isChannelValid(channel)) {
                this.scheduleTimeouts(future);
            }
        }
        catch (Exception e) {
            LOGGER.error("Can't write request", (Throwable)e);
            this.abort(channel, future, e);
        }
    }

    private void configureTransferAdapter(AsyncHandler<?> handler, HttpRequest httpRequest) {
        FluentCaseInsensitiveStringsMap h = new FluentCaseInsensitiveStringsMap();
        for (Map.Entry entries : httpRequest.headers()) {
            h.add((String)entries.getKey(), (String)entries.getValue());
        }
        TransferCompletionHandler transferCompletionHandler = (TransferCompletionHandler)handler;
        transferCompletionHandler.patchForNetty3();
        transferCompletionHandler.headers(h);
    }

    private void scheduleTimeouts(NettyResponseFuture<?> nettyResponseFuture) {
        int readTimeoutValue;
        nettyResponseFuture.touch();
        int requestTimeoutInMs = AsyncHttpProviderUtils.requestTimeout((AsyncHttpClientConfig)this.config, (Request)nettyResponseFuture.getRequest());
        TimeoutsHolder timeoutsHolder = new TimeoutsHolder();
        if (requestTimeoutInMs != -1) {
            Timeout requestTimeout;
            timeoutsHolder.requestTimeout = requestTimeout = this.newTimeout(new RequestTimeoutTimerTask(nettyResponseFuture, this, timeoutsHolder, requestTimeoutInMs), requestTimeoutInMs);
        }
        if ((readTimeoutValue = this.config.getReadTimeout()) != -1 && readTimeoutValue < requestTimeoutInMs) {
            Timeout readTimeout;
            timeoutsHolder.readTimeout = readTimeout = this.newTimeout(new ReadTimeoutTimerTask(nettyResponseFuture, this, timeoutsHolder, requestTimeoutInMs, readTimeoutValue), readTimeoutValue);
        }
        nettyResponseFuture.setTimeoutsHolder(timeoutsHolder);
    }

    public Timeout newTimeout(TimerTask task, long delay) {
        return this.nettyTimer.newTimeout(task, delay, TimeUnit.MILLISECONDS);
    }

    public void abort(Channel channel, NettyResponseFuture<?> future, Throwable t) {
        if (channel != null) {
            this.channelManager.closeChannel(channel);
        }
        if (!future.isDone()) {
            future.setState(NettyResponseFuture.STATE.CLOSED);
            LOGGER.debug("Aborting Future {}\n", future);
            LOGGER.debug(t.getMessage(), t);
            future.abort(t);
        }
    }

    public void handleUnexpectedClosedChannel(Channel channel, NettyResponseFuture<?> future) {
        if (future.isDone()) {
            this.channelManager.closeChannel(channel);
        } else if (!this.retry(future)) {
            this.abort(channel, future, AsyncHttpProviderUtils.REMOTELY_CLOSED_EXCEPTION);
        }
    }

    public boolean retry(NettyResponseFuture<?> future) {
        if (this.isClosed()) {
            return false;
        }
        if (future.canBeReplayed()) {
            future.setState(NettyResponseFuture.STATE.RECONNECTED);
            future.getAndSetStatusReceived(false);
            LOGGER.debug("Trying to recover request {}\n", (Object)future.getNettyRequest().getHttpRequest());
            if (future.getAsyncHandler() instanceof AsyncHandlerExtensions) {
                ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(future.getAsyncHandler())).onRetry();
            }
            try {
                this.sendNextRequest(future.getRequest(), future);
                return true;
            }
            catch (Exception e) {
                this.abort(future.channel(), future, e);
                return false;
            }
        }
        LOGGER.debug("Unable to recover future {}\n", future);
        return false;
    }

    public boolean applyIoExceptionFiltersAndReplayRequest(NettyResponseFuture<?> future, IOException e, Channel channel) {
        boolean replayed = false;
        FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(future.getAsyncHandler()).request(future.getRequest()).ioException(e).build();
        for (IOExceptionFilter asyncFilter : this.config.getIOExceptionFilters()) {
            try {
                if ((fc = asyncFilter.filter(fc)) != null) continue;
                throw new NullPointerException("FilterContext is null");
            }
            catch (FilterException efe) {
                this.abort(channel, future, efe);
            }
        }
        if (fc.replayRequest() && future.canBeReplayed()) {
            this.replayRequest(future, fc, channel);
            replayed = true;
        }
        return replayed;
    }

    public <T> void sendNextRequest(Request request, NettyResponseFuture<T> future) {
        this.sendRequest(request, future.getAsyncHandler(), future, true);
    }

    private void validateWebSocketRequest(Request request, AsyncHandler<?> asyncHandler) {
        Uri uri = request.getUri();
        boolean isWs = uri.getScheme().startsWith("ws");
        if (asyncHandler instanceof WebSocketUpgradeHandler) {
            if (!isWs) {
                throw new IllegalArgumentException("WebSocketUpgradeHandler but scheme isn't ws or wss: " + uri.getScheme());
            }
            if (!request.getMethod().equals(HttpMethod.GET.getName())) {
                throw new IllegalArgumentException("WebSocketUpgradeHandler but method isn't GET: " + request.getMethod());
            }
        } else if (isWs) {
            throw new IllegalArgumentException("No WebSocketUpgradeHandler but scheme is " + uri.getScheme());
        }
    }

    public Channel pollAndVerifyCachedChannel(Request request, ProxyServer proxy, AsyncHandler<?> asyncHandler) {
        String virtualHost;
        Uri uri;
        Channel channel;
        if (asyncHandler instanceof AsyncHandlerExtensions) {
            ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(asyncHandler)).onConnectionPool();
        }
        if ((channel = this.channelManager.poll(uri = request.getUri(), virtualHost = request.getVirtualHost(), proxy, request.getConnectionPoolPartitioning())) != null) {
            LOGGER.debug("Using cached Channel {}\n for uri {}\n", (Object)channel, (Object)uri);
            try {
                this.channelManager.verifyChannelPipeline(channel.getPipeline(), uri, virtualHost);
            }
            catch (Exception ex) {
                LOGGER.debug(ex.getMessage(), (Throwable)ex);
            }
        }
        return channel;
    }

    public void replayRequest(NettyResponseFuture<?> future, FilterContext fc, Channel channel) {
        Request newRequest = fc.getRequest();
        future.setAsyncHandler(fc.getAsyncHandler());
        future.setState(NettyResponseFuture.STATE.NEW);
        future.touch();
        LOGGER.debug("\n\nReplaying Request {}\n for Future {}\n", (Object)newRequest, future);
        if (future.getAsyncHandler() instanceof AsyncHandlerExtensions) {
            ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(future.getAsyncHandler())).onRetry();
        }
        this.channelManager.drainChannelAndOffer(channel, future);
        this.sendNextRequest(newRequest, future);
    }

    public boolean isClosed() {
        return this.closed.get();
    }
}

