/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.request;

import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.AsyncHttpProviderUtils;
import org.asynchttpclient.util.HttpUtils;
import org.asynchttpclient.util.MiscUtils;

public abstract class NettyRequestFactoryBase {
    protected final AsyncHttpClientConfig config;

    public NettyRequestFactoryBase(AsyncHttpClientConfig config) {
        this.config = config;
    }

    protected String requestUri(Uri uri, ProxyServer proxyServer, boolean connect) {
        if (connect) {
            return AsyncHttpProviderUtils.getAuthority((Uri)uri);
        }
        if (proxyServer != null && !HttpUtils.useProxyConnect((Uri)uri)) {
            return uri.toUrl();
        }
        String path = AsyncHttpProviderUtils.getNonEmptyPath((Uri)uri);
        if (MiscUtils.isNonEmpty((String)uri.getQuery())) {
            return path + "?" + uri.getQuery();
        }
        return path;
    }

    protected String connectionHeader(boolean allowConnectionPooling, boolean http11) {
        if (allowConnectionPooling) {
            return "keep-alive";
        }
        if (http11) {
            return "close";
        }
        return null;
    }
}

