/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.handler;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.FluentCaseInsensitiveStringsMap;
import org.asynchttpclient.HttpResponseHeaders;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.cookie.Cookie;
import org.asynchttpclient.cookie.CookieDecoder;
import org.asynchttpclient.filter.FilterContext;
import org.asynchttpclient.filter.FilterException;
import org.asynchttpclient.filter.ResponseFilter;
import org.asynchttpclient.handler.MaxRedirectException;
import org.asynchttpclient.netty.NettyAsyncHttpProviderConfig;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.channel.ChannelManager;
import org.asynchttpclient.netty.request.NettyRequestSender;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.AsyncHttpProviderUtils;
import org.asynchttpclient.util.MiscUtils;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Protocol {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ChannelManager channelManager;
    protected final AsyncHttpClientConfig config;
    protected final NettyAsyncHttpProviderConfig nettyConfig;
    protected final NettyRequestSender requestSender;
    private final boolean hasResponseFilters;
    protected final boolean hasIOExceptionFilters;
    private final MaxRedirectException maxRedirectException;
    public static final Set<Integer> REDIRECT_STATUSES = new HashSet<Integer>();

    public Protocol(ChannelManager channelManager, AsyncHttpClientConfig config, NettyAsyncHttpProviderConfig nettyConfig, NettyRequestSender requestSender) {
        this.channelManager = channelManager;
        this.config = config;
        this.nettyConfig = nettyConfig;
        this.requestSender = requestSender;
        this.hasResponseFilters = !config.getResponseFilters().isEmpty();
        this.hasIOExceptionFilters = !config.getIOExceptionFilters().isEmpty();
        this.maxRedirectException = new MaxRedirectException("Maximum redirect reached: " + config.getMaxRedirects());
    }

    public abstract void handle(Channel var1, NettyResponseFuture<?> var2, Object var3) throws Exception;

    public abstract void onError(NettyResponseFuture<?> var1, Throwable var2);

    public abstract void onClose(NettyResponseFuture<?> var1);

    private FluentCaseInsensitiveStringsMap propagatedHeaders(Request request, Realm realm, boolean switchToGet) {
        FluentCaseInsensitiveStringsMap headers = request.getHeaders().delete("Host").delete("Content-Length").delete("Content-Type");
        if (realm != null && realm.getScheme() == Realm.AuthScheme.NTLM) {
            headers.delete("Authorization").delete("Proxy-Authorization");
        }
        return headers;
    }

    protected boolean exitAfterHandlingRedirect(Channel channel, NettyResponseFuture<?> future, HttpResponse response, Request request, int statusCode, Realm realm) throws Exception {
        if (AsyncHttpProviderUtils.followRedirect((AsyncHttpClientConfig)this.config, (Request)request) && REDIRECT_STATUSES.contains(statusCode)) {
            if (future.incrementAndGetCurrentRedirectCount() >= this.config.getMaxRedirects()) {
                throw this.maxRedirectException;
            }
            future.getAndSetAuth(false);
            String originalMethod = request.getMethod();
            boolean switchToGet = !originalMethod.equals("GET") && (statusCode == 303 || statusCode == 302 && !this.config.isStrict302Handling());
            boolean keepBody = statusCode == 307 || statusCode == 302 && this.config.isStrict302Handling();
            RequestBuilder requestBuilder = (RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)new RequestBuilder(switchToGet ? "GET" : originalMethod).setCookies(request.getCookies())).setConnectionPoolPartitioning(request.getConnectionPoolPartitioning())).setFollowRedirect(true)).setLocalInetAddress(request.getLocalAddress())).setNameResolver(request.getNameResolver())).setProxyServer(request.getProxyServer())).setRealm(request.getRealm())).setRequestTimeout(request.getRequestTimeout());
            if (keepBody) {
                requestBuilder.setBodyCharset(request.getBodyCharset());
                if (MiscUtils.isNonEmpty((Collection)request.getFormParams())) {
                    requestBuilder.setFormParams(request.getFormParams());
                } else if (request.getStringData() != null) {
                    requestBuilder.setBody(request.getStringData());
                } else if (request.getByteData() != null) {
                    requestBuilder.setBody(request.getByteData());
                } else if (request.getByteBufferData() != null) {
                    requestBuilder.setBody(request.getByteBufferData());
                } else if (request.getBodyGenerator() != null) {
                    requestBuilder.setBody(request.getBodyGenerator());
                }
            }
            requestBuilder.setHeaders(this.propagatedHeaders(request, realm, switchToGet));
            boolean initialConnectionKeepAlive = future.isKeepAlive();
            Object initialPartitionKey = future.getPartitionKey();
            HttpHeaders responseHeaders = response.headers();
            String location = responseHeaders.get("Location");
            Uri newUri = Uri.create((Uri)future.getUri(), (String)location);
            this.logger.debug("Redirecting to {}", (Object)newUri);
            for (String cookieStr : responseHeaders.getAll("Set-Cookie")) {
                Cookie c = CookieDecoder.decode((String)cookieStr);
                if (c == null) continue;
                requestBuilder.addOrReplaceCookie(c);
            }
            requestBuilder.setHeaders(this.propagatedHeaders(future.getRequest(), realm, switchToGet));
            boolean sameBase = AsyncHttpProviderUtils.isSameBase((Uri)request.getUri(), (Uri)newUri);
            if (sameBase) {
                requestBuilder.setVirtualHost(request.getVirtualHost());
            }
            Request nextRequest = ((RequestBuilder)requestBuilder.setUri(newUri)).build();
            this.logger.debug("Sending redirect to {}", (Object)newUri);
            if (future.isKeepAlive() && !HttpHeaders.isTransferEncodingChunked((HttpMessage)response) && !response.isChunked()) {
                if (sameBase) {
                    future.setReuseChannel(true);
                } else {
                    this.channelManager.drainChannelAndOffer(channel, future, initialConnectionKeepAlive, initialPartitionKey);
                }
            } else {
                this.channelManager.closeChannel(channel);
            }
            this.requestSender.sendNextRequest(nextRequest, future);
            return true;
        }
        return false;
    }

    protected boolean exitAfterProcessingFilters(Channel channel, NettyResponseFuture<?> future, AsyncHandler<?> handler, HttpResponseStatus status, HttpResponseHeaders responseHeaders) {
        if (this.hasResponseFilters) {
            FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(handler).request(future.getRequest()).responseStatus(status).responseHeaders(responseHeaders).build();
            for (ResponseFilter asyncFilter : this.config.getResponseFilters()) {
                try {
                    if ((fc = asyncFilter.filter(fc)) != null) continue;
                    throw new NullPointerException("FilterContext is null");
                }
                catch (FilterException efe) {
                    this.requestSender.abort(channel, future, efe);
                }
            }
            future.setAsyncHandler(fc.getAsyncHandler());
            if (fc.replayRequest()) {
                this.requestSender.replayRequest(future, fc, channel);
                return true;
            }
        }
        return false;
    }

    static {
        REDIRECT_STATUSES.add(org.jboss.netty.handler.codec.http.HttpResponseStatus.MOVED_PERMANENTLY.getCode());
        REDIRECT_STATUSES.add(org.jboss.netty.handler.codec.http.HttpResponseStatus.FOUND.getCode());
        REDIRECT_STATUSES.add(org.jboss.netty.handler.codec.http.HttpResponseStatus.SEE_OTHER.getCode());
        REDIRECT_STATUSES.add(org.jboss.netty.handler.codec.http.HttpResponseStatus.TEMPORARY_REDIRECT.getCode());
    }
}

