/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.handler;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.FluentCaseInsensitiveStringsMap;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseHeaders;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.channel.pool.ConnectionStrategy;
import org.asynchttpclient.netty.NettyAsyncHttpProviderConfig;
import org.asynchttpclient.netty.NettyResponseBodyPart;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.NettyResponseHeaders;
import org.asynchttpclient.netty.NettyResponseStatus;
import org.asynchttpclient.netty.channel.ChannelManager;
import org.asynchttpclient.netty.handler.Protocol;
import org.asynchttpclient.netty.request.NettyRequestSender;
import org.asynchttpclient.ntlm.NtlmEngine;
import org.asynchttpclient.ntlm.NtlmUtils;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.spnego.SpnegoEngine;
import org.asynchttpclient.spnego.SpnegoEngineException;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.AsyncHttpProviderUtils;
import org.asynchttpclient.util.MiscUtils;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;

public final class HttpProtocol
extends Protocol {
    private final ConnectionStrategy<HttpRequest, HttpResponse> connectionStrategy;

    public HttpProtocol(ChannelManager channelManager, AsyncHttpClientConfig config, NettyAsyncHttpProviderConfig nettyConfig, NettyRequestSender requestSender) {
        super(channelManager, config, nettyConfig, requestSender);
        this.connectionStrategy = nettyConfig.getConnectionStrategy();
    }

    private Realm kerberosChallenge(Channel channel, List<String> authHeaders, Request request, FluentCaseInsensitiveStringsMap headers, Realm realm, NettyResponseFuture<?> future) {
        Uri uri = request.getUri();
        String host = request.getVirtualHost() == null ? uri.getHost() : request.getVirtualHost();
        try {
            String challengeHeader = SpnegoEngine.instance().generateToken(host);
            headers.remove((Object)"Authorization");
            headers.add("Authorization", "Negotiate " + challengeHeader);
            return new Realm.RealmBuilder().clone(realm).setUri(uri).setMethodName(request.getMethod()).setScheme(Realm.AuthScheme.KERBEROS).build();
        }
        catch (SpnegoEngineException throwable) {
            String ntlmAuthenticate = NtlmUtils.getNTLM(authHeaders);
            if (ntlmAuthenticate != null) {
                return this.ntlmChallenge(ntlmAuthenticate, request, headers, realm, future);
            }
            this.requestSender.abort(channel, future, throwable);
            return null;
        }
    }

    private Realm kerberosProxyChallenge(Channel channel, List<String> proxyAuth, Request request, ProxyServer proxyServer, FluentCaseInsensitiveStringsMap headers, NettyResponseFuture<?> future) {
        try {
            String challengeHeader = SpnegoEngine.instance().generateToken(proxyServer.getHost());
            headers.remove((Object)"Authorization");
            headers.add("Authorization", "Negotiate " + challengeHeader);
            return proxyServer.realmBuilder().setUri(request.getUri()).setMethodName(request.getMethod()).setScheme(Realm.AuthScheme.KERBEROS).build();
        }
        catch (SpnegoEngineException throwable) {
            String ntlmAuthenticate = NtlmUtils.getNTLM(proxyAuth);
            if (ntlmAuthenticate != null) {
                return this.ntlmProxyChallenge(ntlmAuthenticate, request, proxyServer, headers, future);
            }
            this.requestSender.abort(channel, future, throwable);
            return null;
        }
    }

    private String authorizationHeaderName(boolean proxyInd) {
        return proxyInd ? "Proxy-Authorization" : "Authorization";
    }

    private void addNTLMAuthorizationHeader(FluentCaseInsensitiveStringsMap headers, String challengeHeader, boolean proxyInd) {
        headers.add(this.authorizationHeaderName(proxyInd), "NTLM " + challengeHeader);
    }

    private Realm ntlmChallenge(String authenticateHeader, Request request, FluentCaseInsensitiveStringsMap headers, Realm realm, NettyResponseFuture<?> future) {
        if (authenticateHeader.equals("NTLM")) {
            String challengeHeader = NtlmEngine.INSTANCE.generateType1Msg();
            this.addNTLMAuthorizationHeader(headers, challengeHeader, false);
            future.getAndSetAuth(false);
        } else {
            this.addType3NTLMAuthorizationHeader(authenticateHeader, headers, realm, false);
        }
        return new Realm.RealmBuilder().clone(realm).setUri(request.getUri()).setMethodName(request.getMethod()).build();
    }

    private Realm ntlmProxyChallenge(String authenticateHeader, Request request, ProxyServer proxyServer, FluentCaseInsensitiveStringsMap headers, NettyResponseFuture<?> future) {
        future.getAndSetAuth(false);
        headers.remove((Object)"Proxy-Authorization");
        Realm realm = proxyServer.realmBuilder().setScheme(Realm.AuthScheme.NTLM).setUri(request.getUri()).setMethodName(request.getMethod()).build();
        this.addType3NTLMAuthorizationHeader(authenticateHeader, headers, realm, true);
        return realm;
    }

    private void addType3NTLMAuthorizationHeader(String auth, FluentCaseInsensitiveStringsMap headers, Realm realm, boolean proxyInd) {
        headers.remove((Object)this.authorizationHeaderName(proxyInd));
        if (MiscUtils.isNonEmpty((String)auth) && auth.startsWith("NTLM ")) {
            String serverChallenge = auth.substring("NTLM ".length()).trim();
            String challengeHeader = NtlmEngine.INSTANCE.generateType3Msg(realm.getPrincipal(), realm.getPassword(), realm.getNtlmDomain(), realm.getNtlmHost(), serverChallenge);
            this.addNTLMAuthorizationHeader(headers, challengeHeader, proxyInd);
        }
    }

    private void finishUpdate(NettyResponseFuture<?> future, Channel channel, boolean expectOtherChunks) {
        future.cancelTimeouts();
        boolean keepAlive = future.isKeepAlive();
        if (expectOtherChunks && keepAlive) {
            this.channelManager.drainChannelAndOffer(channel, future);
        } else {
            this.channelManager.tryToOfferChannelToPool(channel, future.getAsyncHandler(), keepAlive, future.getPartitionKey());
        }
        try {
            future.done();
        }
        catch (Exception t) {
            this.logger.debug(t.getMessage(), (Throwable)t);
        }
    }

    private boolean updateBodyAndInterrupt(NettyResponseFuture<?> future, AsyncHandler<?> handler, NettyResponseBodyPart bodyPart) throws Exception {
        boolean interrupt;
        boolean bl = interrupt = handler.onBodyPartReceived((HttpResponseBodyPart)bodyPart) != AsyncHandler.State.CONTINUE;
        if (bodyPart.isUnderlyingConnectionToBeClosed()) {
            future.setKeepAlive(false);
        }
        return interrupt;
    }

    private boolean exitAfterHandling401(Channel channel, NettyResponseFuture<?> future, HttpResponse response, Request request, int statusCode, Realm realm, ProxyServer proxyServer) {
        List wwwAuthHeaders;
        if (statusCode == org.jboss.netty.handler.codec.http.HttpResponseStatus.UNAUTHORIZED.getCode() && realm != null && !future.getAndSetAuth(true) && !(wwwAuthHeaders = response.headers().getAll("WWW-Authenticate")).isEmpty()) {
            future.setState(NettyResponseFuture.STATE.NEW);
            Realm newRealm = null;
            boolean negociate = wwwAuthHeaders.contains("Negotiate");
            String ntlmAuthenticate = NtlmUtils.getNTLM((List)wwwAuthHeaders);
            if (!wwwAuthHeaders.contains("Kerberos") && ntlmAuthenticate != null) {
                newRealm = this.ntlmChallenge(ntlmAuthenticate, request, request.getHeaders(), realm, future);
            } else if (negociate) {
                newRealm = this.kerberosChallenge(channel, wwwAuthHeaders, request, request.getHeaders(), realm, future);
                if (newRealm == null) {
                    return true;
                }
            } else {
                newRealm = new Realm.RealmBuilder().clone(realm).setUri(request.getUri()).setMethodName(request.getMethod()).setUsePreemptiveAuth(true).parseWWWAuthenticateHeader((String)wwwAuthHeaders.get(0)).build();
            }
            Request nextRequest = ((RequestBuilder)((RequestBuilder)new RequestBuilder(future.getRequest()).setHeaders(request.getHeaders())).setRealm(newRealm)).build();
            this.logger.debug("Sending authentication to {}", (Object)request.getUri());
            if (future.isKeepAlive() && !HttpHeaders.isTransferEncodingChunked((HttpMessage)response) && !response.isChunked()) {
                future.setReuseChannel(true);
            } else {
                this.channelManager.closeChannel(channel);
            }
            this.requestSender.sendNextRequest(nextRequest, future);
            return true;
        }
        return false;
    }

    private boolean exitAfterHandling100(Channel channel, NettyResponseFuture<?> future, int statusCode) {
        if (statusCode == org.jboss.netty.handler.codec.http.HttpResponseStatus.CONTINUE.getCode()) {
            future.setHeadersAlreadyWrittenOnContinue(true);
            future.setDontWriteBodyBecauseExpectContinue(false);
            this.requestSender.writeRequest(future, channel);
            return true;
        }
        return false;
    }

    private boolean exitAfterHandling407(Channel channel, NettyResponseFuture<?> future, HttpResponse response, Request request, int statusCode, Realm realm, ProxyServer proxyServer) {
        List proxyAuthHeaders;
        if (statusCode == org.jboss.netty.handler.codec.http.HttpResponseStatus.PROXY_AUTHENTICATION_REQUIRED.getCode() && realm != null && !future.getAndSetAuth(true) && !(proxyAuthHeaders = response.headers().getAll("Proxy-Authenticate")).isEmpty()) {
            this.logger.debug("Sending proxy authentication to {}", (Object)request.getUri());
            future.setState(NettyResponseFuture.STATE.NEW);
            Realm newRealm = null;
            FluentCaseInsensitiveStringsMap requestHeaders = request.getHeaders();
            boolean negociate = proxyAuthHeaders.contains("Negotiate");
            String ntlmAuthenticate = NtlmUtils.getNTLM((List)proxyAuthHeaders);
            if (!proxyAuthHeaders.contains("Kerberos") && ntlmAuthenticate != null) {
                newRealm = this.ntlmProxyChallenge(ntlmAuthenticate, request, proxyServer, requestHeaders, future);
            } else if (negociate) {
                newRealm = this.kerberosProxyChallenge(channel, proxyAuthHeaders, request, proxyServer, requestHeaders, future);
                if (newRealm == null) {
                    return true;
                }
            } else {
                newRealm = new Realm.RealmBuilder().clone(realm).setUri(request.getUri()).setOmitQuery(true).setMethodName(request.getMethod()).setUsePreemptiveAuth(true).parseProxyAuthenticateHeader((String)proxyAuthHeaders.get(0)).build();
            }
            Request nextRequest = ((RequestBuilder)((RequestBuilder)new RequestBuilder(future.getRequest()).setHeaders(request.getHeaders())).setRealm(newRealm)).build();
            this.logger.debug("Sending proxy authentication to {}", (Object)request.getUri());
            if (future.isKeepAlive() && !HttpHeaders.isTransferEncodingChunked((HttpMessage)response) && !response.isChunked()) {
                future.setConnectAllowed(true);
                future.setReuseChannel(true);
            } else {
                this.channelManager.closeChannel(channel);
            }
            this.requestSender.sendNextRequest(nextRequest, future);
            return true;
        }
        return false;
    }

    private boolean exitAfterHandlingConnect(Channel channel, NettyResponseFuture<?> future, Request request, ProxyServer proxyServer, int statusCode, HttpRequest httpRequest) {
        if (statusCode == org.jboss.netty.handler.codec.http.HttpResponseStatus.OK.getCode() && httpRequest.getMethod() == HttpMethod.CONNECT) {
            if (future.isKeepAlive()) {
                future.attachChannel(channel, true);
            }
            Uri requestUri = request.getUri();
            String scheme = requestUri.getScheme();
            String host = requestUri.getHost();
            int port = AsyncHttpProviderUtils.getExplicitPort((Uri)requestUri);
            this.logger.debug("Connecting to proxy {} for scheme {}", (Object)proxyServer, (Object)scheme);
            try {
                this.channelManager.upgradeProtocol(channel.getPipeline(), scheme, host, port);
                future.setReuseChannel(true);
                future.setConnectAllowed(false);
                this.requestSender.sendNextRequest(new RequestBuilder(future.getRequest()).build(), future);
            }
            catch (GeneralSecurityException ex) {
                this.requestSender.abort(channel, future, ex);
            }
            return true;
        }
        return false;
    }

    private boolean exitAfterHandlingStatus(Channel channel, NettyResponseFuture<?> future, HttpResponse response, AsyncHandler<?> handler, NettyResponseStatus status) throws Exception {
        if (!future.getAndSetStatusReceived(true) && handler.onStatusReceived((HttpResponseStatus)status) != AsyncHandler.State.CONTINUE) {
            this.finishUpdate(future, channel, HttpHeaders.isTransferEncodingChunked((HttpMessage)response));
            return true;
        }
        return false;
    }

    private boolean exitAfterHandlingHeaders(Channel channel, NettyResponseFuture<?> future, HttpResponse response, AsyncHandler<?> handler, NettyResponseHeaders responseHeaders) throws Exception {
        if (!response.headers().isEmpty() && handler.onHeadersReceived((HttpResponseHeaders)responseHeaders) != AsyncHandler.State.CONTINUE) {
            this.finishUpdate(future, channel, HttpHeaders.isTransferEncodingChunked((HttpMessage)response));
            return true;
        }
        return false;
    }

    private boolean exitAfterHandlingBody(Channel channel, NettyResponseFuture<?> future, HttpResponse response, AsyncHandler<?> handler) throws Exception {
        if (!response.isChunked()) {
            if (response.getContent().readableBytes() > 0) {
                this.updateBodyAndInterrupt(future, handler, new NettyResponseBodyPart(response, null, true));
            }
            this.finishUpdate(future, channel, false);
            return true;
        }
        return false;
    }

    private boolean handleHttpResponse(HttpResponse response, Channel channel, NettyResponseFuture<?> future, AsyncHandler<?> handler) throws Exception {
        HttpRequest httpRequest = future.getNettyRequest().getHttpRequest();
        ProxyServer proxyServer = future.getProxyServer();
        this.logger.debug("\n\nRequest {}\n\nResponse {}\n", (Object)httpRequest, (Object)response);
        future.setHttpHeaders(response.headers());
        future.setKeepAlive(this.connectionStrategy.keepAlive((Object)httpRequest, (Object)response));
        NettyResponseStatus status = new NettyResponseStatus(future.getUri(), this.config, response, channel);
        int statusCode = response.getStatus().getCode();
        Request request = future.getRequest();
        Realm realm = request.getRealm() != null ? request.getRealm() : this.config.getRealm();
        NettyResponseHeaders responseHeaders = new NettyResponseHeaders(response.headers());
        return this.exitAfterProcessingFilters(channel, future, handler, status, responseHeaders) || this.exitAfterHandling401(channel, future, response, request, statusCode, realm, proxyServer) || this.exitAfterHandling407(channel, future, response, request, statusCode, realm, proxyServer) || this.exitAfterHandling100(channel, future, statusCode) || this.exitAfterHandlingRedirect(channel, future, response, request, statusCode, realm) || this.exitAfterHandlingConnect(channel, future, request, proxyServer, statusCode, httpRequest) || this.exitAfterHandlingStatus(channel, future, response, handler, status) || this.exitAfterHandlingHeaders(channel, future, response, handler, responseHeaders) || this.exitAfterHandlingBody(channel, future, response, handler);
    }

    private void handleChunk(HttpChunk chunk, Channel channel, NettyResponseFuture<?> future, AsyncHandler<?> handler) throws Exception {
        boolean last = chunk.isLast();
        if (last || this.updateBodyAndInterrupt(future, handler, new NettyResponseBodyPart(null, chunk, last))) {
            HttpChunkTrailer chunkTrailer;
            if (chunk instanceof HttpChunkTrailer && !(chunkTrailer = (HttpChunkTrailer)chunk).trailingHeaders().isEmpty()) {
                NettyResponseHeaders responseHeaders = new NettyResponseHeaders(future.getHttpHeaders(), chunkTrailer.trailingHeaders());
                handler.onHeadersReceived((HttpResponseHeaders)responseHeaders);
            }
            this.finishUpdate(future, channel, !chunk.isLast());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(Channel channel, NettyResponseFuture<?> future, Object e) throws Exception {
        future.touch();
        if (future.isDone()) {
            this.channelManager.closeChannel(channel);
            return;
        }
        AsyncHandler<?> handler = future.getAsyncHandler();
        try {
            if (e instanceof HttpResponse) {
                if (this.handleHttpResponse((HttpResponse)e, channel, future, handler)) {
                    return;
                }
            } else if (e instanceof HttpChunk) {
                this.handleChunk((HttpChunk)e, channel, future, handler);
            }
        }
        catch (Exception t) {
            if (this.hasIOExceptionFilters && t instanceof IOException && this.requestSender.applyIoExceptionFiltersAndReplayRequest(future, (IOException)IOException.class.cast(t), channel)) {
                return;
            }
            try {
                this.requestSender.abort(channel, future, t);
            }
            catch (Exception abortException) {
                this.logger.debug("Abort failed", (Throwable)abortException);
            }
            finally {
                this.finishUpdate(future, channel, false);
            }
            throw t;
        }
    }

    @Override
    public void onError(NettyResponseFuture<?> future, Throwable e) {
    }

    @Override
    public void onClose(NettyResponseFuture<?> future) {
    }
}

