/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty;

import java.net.SocketAddress;
import java.util.List;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseHeaders;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.Response;
import org.asynchttpclient.netty.NettyResponse;
import org.asynchttpclient.uri.Uri;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.HttpResponse;

public class NettyResponseStatus
extends HttpResponseStatus {
    private final HttpResponse response;
    private final SocketAddress remoteAddress;
    private final SocketAddress localAddress;

    public NettyResponseStatus(Uri uri, AsyncHttpClientConfig config, HttpResponse response, Channel channel) {
        super(uri, config);
        this.response = response;
        if (channel != null) {
            this.remoteAddress = channel.getRemoteAddress();
            this.localAddress = channel.getLocalAddress();
        } else {
            this.remoteAddress = null;
            this.localAddress = null;
        }
    }

    public int getStatusCode() {
        return this.response.getStatus().getCode();
    }

    public String getStatusText() {
        return this.response.getStatus().getReasonPhrase();
    }

    public String getProtocolName() {
        return this.response.getProtocolVersion().getProtocolName();
    }

    public int getProtocolMajorVersion() {
        return this.response.getProtocolVersion().getMajorVersion();
    }

    public int getProtocolMinorVersion() {
        return this.response.getProtocolVersion().getMinorVersion();
    }

    public String getProtocolText() {
        return this.response.getProtocolVersion().getText();
    }

    public Response prepareResponse(HttpResponseHeaders headers, List<HttpResponseBodyPart> bodyParts) {
        return new NettyResponse(this, headers, bodyParts);
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }
}

