/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.ws;

import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.netty.NettyResponseBodyPart;
import org.asynchttpclient.netty.util.ChannelBufferUtils;
import org.asynchttpclient.ws.WebSocket;
import org.asynchttpclient.ws.WebSocketByteFragmentListener;
import org.asynchttpclient.ws.WebSocketByteListener;
import org.asynchttpclient.ws.WebSocketCloseCodeReasonListener;
import org.asynchttpclient.ws.WebSocketListener;
import org.asynchttpclient.ws.WebSocketPingListener;
import org.asynchttpclient.ws.WebSocketPongListener;
import org.asynchttpclient.ws.WebSocketTextFragmentListener;
import org.asynchttpclient.ws.WebSocketTextListener;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyWebSocket
implements WebSocket {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyWebSocket.class);
    protected final Channel channel;
    protected final Collection<WebSocketListener> listeners;
    protected final int maxBufferSize;
    private int bufferSize;
    private List<ChannelBuffer> _fragments;
    private volatile boolean interestedInByteMessages;
    private volatile boolean interestedInTextMessages;

    public NettyWebSocket(Channel channel, AsyncHttpClientConfig config) {
        this(channel, config, new ConcurrentLinkedQueue<WebSocketListener>());
    }

    public NettyWebSocket(Channel channel, AsyncHttpClientConfig config, Collection<WebSocketListener> listeners) {
        this.channel = channel;
        this.listeners = listeners;
        this.maxBufferSize = config.getWebSocketMaxBufferSize();
    }

    public SocketAddress getRemoteAddress() {
        return this.channel.getRemoteAddress();
    }

    public SocketAddress getLocalAddress() {
        return this.channel.getLocalAddress();
    }

    public WebSocket sendMessage(byte[] message) {
        this.channel.write((Object)new BinaryWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])message)));
        return this;
    }

    public WebSocket stream(byte[] fragment, boolean last) {
        BinaryWebSocketFrame frame = new BinaryWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])fragment));
        frame.setFinalFragment(last);
        this.channel.write((Object)frame);
        return this;
    }

    public WebSocket stream(byte[] fragment, int offset, int len, boolean last) {
        BinaryWebSocketFrame frame = new BinaryWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])fragment, (int)offset, (int)len));
        frame.setFinalFragment(last);
        this.channel.write((Object)frame);
        return this;
    }

    public WebSocket sendMessage(String message) {
        this.channel.write((Object)new TextWebSocketFrame(message));
        return this;
    }

    public WebSocket stream(String fragment, boolean last) {
        TextWebSocketFrame frame = new TextWebSocketFrame(fragment);
        frame.setFinalFragment(last);
        this.channel.write((Object)frame);
        return this;
    }

    public WebSocket sendPing(byte[] payload) {
        this.channel.write((Object)new PingWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])payload)));
        return this;
    }

    public WebSocket sendPong(byte[] payload) {
        this.channel.write((Object)new PongWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])payload)));
        return this;
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void close() {
        if (this.channel.isOpen()) {
            this.onClose();
            this.listeners.clear();
            this.channel.write((Object)new CloseWebSocketFrame()).addListener(ChannelFutureListener.CLOSE);
        }
    }

    public void close(int statusCode, String reason) {
        this.onClose(statusCode, reason);
        this.listeners.clear();
    }

    public void onError(Throwable t) {
        for (WebSocketListener listener : this.listeners) {
            try {
                listener.onError(t);
            }
            catch (Throwable t2) {
                LOGGER.error("", t2);
            }
        }
    }

    protected void onClose() {
        this.onClose(1000, "Normal closure; the connection successfully completed whatever purpose for which it was created.");
    }

    public void onClose(int code, String reason) {
        for (WebSocketListener l : this.listeners) {
            try {
                if (l instanceof WebSocketCloseCodeReasonListener) {
                    ((WebSocketCloseCodeReasonListener)WebSocketCloseCodeReasonListener.class.cast(l)).onClose((WebSocket)this, code, reason);
                }
                l.onClose((WebSocket)this);
            }
            catch (Throwable t) {
                l.onError(t);
            }
        }
    }

    public String toString() {
        return "NettyWebSocket{channel=" + this.channel + '}';
    }

    private boolean hasWebSocketByteListener() {
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketByteListener)) continue;
            return true;
        }
        return false;
    }

    private boolean hasWebSocketTextListener() {
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketTextListener)) continue;
            return true;
        }
        return false;
    }

    public WebSocket addWebSocketListener(WebSocketListener l) {
        this.listeners.add(l);
        this.interestedInByteMessages = this.interestedInByteMessages || l instanceof WebSocketByteListener;
        this.interestedInTextMessages = this.interestedInTextMessages || l instanceof WebSocketTextListener;
        return this;
    }

    public WebSocket removeWebSocketListener(WebSocketListener l) {
        this.listeners.remove(l);
        if (l instanceof WebSocketByteListener) {
            this.interestedInByteMessages = this.hasWebSocketByteListener();
        }
        if (l instanceof WebSocketTextListener) {
            this.interestedInTextMessages = this.hasWebSocketTextListener();
        }
        return this;
    }

    private List<ChannelBuffer> fragments() {
        if (this._fragments == null) {
            this._fragments = new ArrayList<ChannelBuffer>(2);
        }
        return this._fragments;
    }

    private void bufferFragment(ChannelBuffer buffer) {
        this.bufferSize += buffer.readableBytes();
        if (this.bufferSize > this.maxBufferSize) {
            this.onError(new Exception("Exceeded Netty Web Socket maximum buffer size of " + this.maxBufferSize));
            this.reset();
            this.close();
        } else {
            this.fragments().add(buffer);
        }
    }

    private void reset() {
        this.fragments().clear();
        this.bufferSize = 0;
    }

    private void notifyByteListeners(ChannelBuffer channelBuffer) {
        byte[] message = ChannelBufferUtils.channelBuffer2bytes(channelBuffer);
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketByteListener)) continue;
            ((WebSocketByteListener)WebSocketByteListener.class.cast(listener)).onMessage(message);
        }
    }

    private void notifyTextListeners(ChannelBuffer channelBuffer) {
        String message = channelBuffer.toString(StandardCharsets.UTF_8);
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketTextListener)) continue;
            ((WebSocketTextListener)WebSocketTextListener.class.cast(listener)).onMessage(message);
        }
    }

    public void onBinaryFragment(HttpResponseBodyPart part) {
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketByteFragmentListener)) continue;
            ((WebSocketByteFragmentListener)WebSocketByteFragmentListener.class.cast(listener)).onFragment(part);
        }
        if (this.interestedInByteMessages) {
            ChannelBuffer fragment = ((NettyResponseBodyPart)((Object)NettyResponseBodyPart.class.cast(part))).getChannelBuffer();
            if (part.isLast()) {
                if (this.bufferSize == 0) {
                    this.notifyByteListeners(fragment);
                } else {
                    this.bufferFragment(fragment);
                    this.notifyByteListeners(ChannelBuffers.wrappedBuffer((ChannelBuffer[])this.fragments().toArray(new ChannelBuffer[this.fragments().size()])));
                }
                this.reset();
            } else {
                this.bufferFragment(fragment);
            }
        }
    }

    public void onTextFragment(HttpResponseBodyPart part) {
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketTextFragmentListener)) continue;
            ((WebSocketTextFragmentListener)WebSocketTextFragmentListener.class.cast(listener)).onFragment(part);
        }
        if (this.interestedInTextMessages) {
            ChannelBuffer fragment = ((NettyResponseBodyPart)((Object)NettyResponseBodyPart.class.cast(part))).getChannelBuffer();
            if (part.isLast()) {
                if (this.bufferSize == 0) {
                    this.notifyTextListeners(fragment);
                } else {
                    this.bufferFragment(fragment);
                    this.notifyTextListeners(ChannelBuffers.wrappedBuffer((ChannelBuffer[])this.fragments().toArray(new ChannelBuffer[this.fragments().size()])));
                }
                this.reset();
            } else {
                this.bufferFragment(fragment);
            }
        }
    }

    public void onPing(HttpResponseBodyPart part) {
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketPingListener)) continue;
            ((WebSocketPingListener)WebSocketPingListener.class.cast(listener)).onPing(part.getBodyPartBytes());
        }
    }

    public void onPong(HttpResponseBodyPart part) {
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketPongListener)) continue;
            ((WebSocketPongListener)WebSocketPongListener.class.cast(listener)).onPong(part.getBodyPartBytes());
        }
    }
}

