/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.timeout;

import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.request.NettyRequestSender;
import org.asynchttpclient.netty.timeout.TimeoutTimerTask;
import org.asynchttpclient.netty.timeout.TimeoutsHolder;
import org.asynchttpclient.util.DateUtils;
import org.jboss.netty.util.Timeout;

public class RequestTimeoutTimerTask
extends TimeoutTimerTask {
    private final long requestTimeout;

    public RequestTimeoutTimerTask(NettyResponseFuture<?> nettyResponseFuture, NettyRequestSender requestSender, TimeoutsHolder timeoutsHolder, long requestTimeout) {
        super(nettyResponseFuture, requestSender, timeoutsHolder);
        this.requestTimeout = requestTimeout;
    }

    public void run(Timeout timeout) throws Exception {
        if (this.done.getAndSet(true) || this.requestSender.isClosed()) {
            return;
        }
        this.timeoutsHolder.cancel();
        if (this.nettyResponseFuture.isDone()) {
            return;
        }
        String message = "Request timed out to " + this.remoteAddress + " of " + this.requestTimeout + " ms";
        long age = DateUtils.millisTime() - this.nettyResponseFuture.getStart();
        this.expire(message, age);
    }
}

