/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.request.body;

import java.nio.ByteBuffer;
import org.asynchttpclient.request.body.Body;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.stream.ChunkedInput;

public class BodyChunkedInput
implements ChunkedInput {
    private static final int DEFAULT_CHUNK_SIZE = 8192;
    private final Body body;
    private final int contentLength;
    private final int chunkSize;
    private boolean endOfInput;

    public BodyChunkedInput(Body body) {
        if (body == null) {
            throw new NullPointerException("body");
        }
        this.body = body;
        this.contentLength = (int)body.getContentLength();
        this.chunkSize = this.contentLength <= 0 ? 8192 : Math.min(this.contentLength, 8192);
    }

    public boolean hasNextChunk() throws Exception {
        throw new UnsupportedOperationException();
    }

    public Object nextChunk() throws Exception {
        if (this.endOfInput) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.allocate(this.chunkSize);
        Body.State state = this.body.read(buffer);
        switch (state) {
            case Stop: {
                this.endOfInput = true;
                return null;
            }
            case Suspend: {
                return null;
            }
            case Continue: {
                buffer.flip();
                return ChannelBuffers.wrappedBuffer((ByteBuffer)buffer);
            }
        }
        throw new IllegalStateException("Unknown state: " + state);
    }

    public boolean isEndOfInput() throws Exception {
        return this.endOfInput;
    }

    public void close() throws Exception {
        this.body.close();
    }
}

