/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.request;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Request;
import org.asynchttpclient.cookie.CookieEncoder;
import org.asynchttpclient.netty.request.NettyRequest;
import org.asynchttpclient.netty.request.NettyRequestFactoryBase;
import org.asynchttpclient.netty.request.body.NettyBody;
import org.asynchttpclient.netty.request.body.NettyBodyBody;
import org.asynchttpclient.netty.request.body.NettyByteArrayBody;
import org.asynchttpclient.netty.request.body.NettyByteBufferBody;
import org.asynchttpclient.netty.request.body.NettyCompositeByteArrayBody;
import org.asynchttpclient.netty.request.body.NettyDirectBody;
import org.asynchttpclient.netty.request.body.NettyFileBody;
import org.asynchttpclient.netty.request.body.NettyInputStreamBody;
import org.asynchttpclient.netty.request.body.NettyMultipartBody;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.request.body.generator.FileBodyGenerator;
import org.asynchttpclient.request.body.generator.InputStreamBodyGenerator;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.AsyncHttpProviderUtils;
import org.asynchttpclient.util.AuthenticatorUtils;
import org.asynchttpclient.util.HttpUtils;
import org.asynchttpclient.util.MiscUtils;
import org.asynchttpclient.util.StringUtils;
import org.asynchttpclient.ws.WebSocketUtils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpVersion;

public final class NettyRequestFactory
extends NettyRequestFactoryBase {
    public static final String GZIP_DEFLATE = "gzip,deflate";

    public NettyRequestFactory(AsyncHttpClientConfig config) {
        super(config);
    }

    private NettyBody body(Request request, boolean connect) {
        NettyBody nettyBody = null;
        if (!connect) {
            Charset bodyCharset;
            Charset charset = bodyCharset = request.getBodyCharset() == null ? AsyncHttpProviderUtils.DEFAULT_CHARSET : request.getBodyCharset();
            if (request.getByteData() != null) {
                nettyBody = new NettyByteArrayBody(request.getByteData());
            } else if (request.getCompositeByteData() != null) {
                nettyBody = new NettyCompositeByteArrayBody(request.getCompositeByteData());
            } else if (request.getStringData() != null) {
                nettyBody = new NettyByteBufferBody(StringUtils.charSequence2ByteBuffer((CharSequence)request.getStringData(), (Charset)bodyCharset));
            } else if (request.getByteBufferData() != null) {
                nettyBody = new NettyByteBufferBody(request.getByteBufferData());
            } else if (request.getStreamData() != null) {
                nettyBody = new NettyInputStreamBody(request.getStreamData(), this.config);
            } else if (MiscUtils.isNonEmpty((Collection)request.getFormParams())) {
                String contentType = null;
                if (!request.getHeaders().containsKey((Object)"Content-Type")) {
                    contentType = "application/x-www-form-urlencoded";
                }
                nettyBody = new NettyByteBufferBody(AsyncHttpProviderUtils.urlEncodeFormParams((List)request.getFormParams(), (Charset)bodyCharset), contentType);
            } else if (MiscUtils.isNonEmpty((Collection)request.getParts())) {
                nettyBody = new NettyMultipartBody(request.getParts(), request.getHeaders(), this.config);
            } else if (request.getFile() != null) {
                nettyBody = new NettyFileBody(request.getFile(), this.config);
            } else if (request.getBodyGenerator() instanceof FileBodyGenerator) {
                FileBodyGenerator fileBodyGenerator = (FileBodyGenerator)request.getBodyGenerator();
                nettyBody = new NettyFileBody(fileBodyGenerator.getFile(), fileBodyGenerator.getRegionSeek(), fileBodyGenerator.getRegionLength(), this.config);
            } else if (request.getBodyGenerator() instanceof InputStreamBodyGenerator) {
                nettyBody = new NettyInputStreamBody(((InputStreamBodyGenerator)InputStreamBodyGenerator.class.cast(request.getBodyGenerator())).getInputStream(), this.config);
            } else if (request.getBodyGenerator() != null) {
                nettyBody = new NettyBodyBody(request.getBodyGenerator().createBody(), this.config);
            }
        }
        return nettyBody;
    }

    public void addAuthorizationHeader(HttpHeaders headers, String authorizationHeader) {
        if (authorizationHeader != null) {
            headers.add("Authorization", (Object)authorizationHeader);
        }
    }

    public void setProxyAuthorizationHeader(HttpHeaders headers, String proxyAuthorizationHeader) {
        if (proxyAuthorizationHeader != null) {
            headers.set("Proxy-Authorization", (Object)proxyAuthorizationHeader);
        }
    }

    public NettyRequest newNettyRequest(Request request, boolean forceConnect, ProxyServer proxyServer) {
        String connectionHeaderValue;
        NettyRequest nettyRequest;
        DefaultHttpRequest httpRequest;
        Uri uri = request.getUri();
        HttpMethod method = forceConnect ? HttpMethod.CONNECT : HttpMethod.valueOf((String)request.getMethod());
        boolean connect = method == HttpMethod.CONNECT;
        boolean allowConnectionPooling = this.config.isAllowPoolingConnections() && (!HttpUtils.isSecure((Uri)uri) || this.config.isAllowPoolingSslConnections());
        HttpVersion httpVersion = !allowConnectionPooling || connect && proxyServer.isForceHttp10() ? HttpVersion.HTTP_1_0 : HttpVersion.HTTP_1_1;
        String requestUri = this.requestUri(uri, proxyServer, connect);
        NettyBody body = this.body(request, connect);
        if (body instanceof NettyDirectBody) {
            ChannelBuffer buffer = ((NettyDirectBody)NettyDirectBody.class.cast(body)).channelBuffer();
            httpRequest = new DefaultHttpRequest(httpVersion, method, requestUri);
            httpRequest.setContent(buffer);
            nettyRequest = new NettyRequest((HttpRequest)httpRequest, null);
        } else {
            httpRequest = new DefaultHttpRequest(httpVersion, method, requestUri);
            nettyRequest = new NettyRequest((HttpRequest)httpRequest, body);
        }
        HttpHeaders headers = httpRequest.headers();
        if (!connect) {
            for (Map.Entry header : request.getHeaders()) {
                headers.set((String)header.getKey(), (Iterable)header.getValue());
            }
            if (MiscUtils.isNonEmpty((Collection)request.getCookies())) {
                headers.set("Cookie", (Object)CookieEncoder.encode((Collection)request.getCookies()));
            }
            if (this.config.isCompressionEnforced() && !headers.contains("Accept-Encoding")) {
                headers.set("Accept-Encoding", (Object)GZIP_DEFLATE);
            }
        }
        if (body != null) {
            if (body.getContentLength() < 0L) {
                headers.set("Transfer-Encoding", (Object)"chunked");
            } else {
                headers.set("Content-Length", (Object)body.getContentLength());
            }
            if (body.getContentType() != null) {
                headers.set("Content-Type", (Object)body.getContentType());
            }
        }
        boolean webSocket = HttpUtils.isWebSocket((String)uri.getScheme());
        if (!connect && webSocket) {
            String origin = "http://" + uri.getHost() + ":" + (uri.getPort() == -1 ? (HttpUtils.isSecure((String)uri.getScheme()) ? 443 : 80) : uri.getPort());
            headers.set("Upgrade", (Object)"WebSocket").set("Connection", (Object)"Upgrade").set("Origin", (Object)origin).set("Sec-WebSocket-Key", (Object)WebSocketUtils.getKey()).set("Sec-WebSocket-Version", (Object)"13");
        } else if (!headers.contains("Connection") && (connectionHeaderValue = this.connectionHeader(allowConnectionPooling, httpVersion == HttpVersion.HTTP_1_1)) != null) {
            headers.set("Connection", (Object)connectionHeaderValue);
        }
        if (!headers.contains("Host")) {
            headers.set("Host", (Object)AsyncHttpProviderUtils.hostHeader((Request)request, (Uri)uri));
        }
        Realm realm = request.getRealm() != null ? request.getRealm() : this.config.getRealm();
        this.addAuthorizationHeader(headers, AuthenticatorUtils.perRequestAuthorizationHeader((Request)request, (Realm)realm));
        this.setProxyAuthorizationHeader(headers, AuthenticatorUtils.perRequestProxyAuthorizationHeader((Request)request, (ProxyServer)proxyServer, (Realm)realm, (boolean)connect));
        if (!headers.contains("Accept")) {
            headers.set("Accept", (Object)"*/*");
        }
        if (!headers.contains("User-Agent") && this.config.getUserAgent() != null) {
            headers.set("User-Agent", (Object)this.config.getUserAgent());
        }
        return nettyRequest;
    }
}

