/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.request;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.Request;
import org.asynchttpclient.channel.ChannelConnector;
import org.asynchttpclient.proxy.ProxyServer;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;

public class NettyChannelConnector
extends ChannelConnector {
    public NettyChannelConnector(Request request, ProxyServer proxy, boolean useProxy, AsyncHandler<?> asyncHandler) throws UnknownHostException {
        super(request, proxy, useProxy, asyncHandler);
    }

    public void connect(final ClientBootstrap bootstrap, final ChannelFutureListener listener) throws UnknownHostException {
        final InetSocketAddress remoteAddress = this.remoteAddresses[this.i];
        ChannelFuture future = this.localAddress != null ? bootstrap.connect((SocketAddress)remoteAddress, (SocketAddress)this.localAddress) : bootstrap.connect((SocketAddress)remoteAddress);
        future.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                boolean retry = false;
                if (future.isSuccess()) {
                    if (NettyChannelConnector.this.asyncHandlerExtensions != null) {
                        NettyChannelConnector.this.asyncHandlerExtensions.onConnectionSuccess((Object)future.getChannel(), remoteAddress.getAddress());
                    }
                } else {
                    if (NettyChannelConnector.this.asyncHandlerExtensions != null) {
                        NettyChannelConnector.this.asyncHandlerExtensions.onConnectionFailure(remoteAddress.getAddress());
                    }
                    retry = NettyChannelConnector.this.pickNextRemoteAddress();
                }
                if (retry) {
                    NettyChannelConnector.this.connect(bootstrap, listener);
                } else {
                    listener.operationComplete(future);
                }
            }
        });
    }
}

