/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.channel;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.asynchttpclient.netty.channel.Channels;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroupFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanupChannelGroup
extends DefaultChannelGroup {
    private static final Logger logger = LoggerFactory.getLogger(CleanupChannelGroup.class);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public CleanupChannelGroup() {
    }

    public CleanupChannelGroup(String name) {
        super(name);
    }

    public ChannelGroupFuture close() {
        this.lock.writeLock().lock();
        try {
            if (!this.closed.getAndSet(true)) {
                ChannelGroupFuture channelGroupFuture = super.close();
                return channelGroupFuture;
            }
            ArrayList futures = new ArrayList();
            logger.debug("CleanupChannelGroup Already closed");
            DefaultChannelGroupFuture defaultChannelGroupFuture = new DefaultChannelGroupFuture((ChannelGroup)ChannelGroup.class.cast((Object)this), futures);
            return defaultChannelGroupFuture;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean add(Channel channel) {
        this.lock.readLock().lock();
        try {
            if (this.closed.get()) {
                Channels.silentlyCloseChannel(channel);
                boolean bl = false;
                return bl;
            }
            boolean bl = super.add(channel);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

