/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.channel;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLEngine;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.channel.SSLEngineFactory;
import org.asynchttpclient.channel.pool.ConnectionPoolPartitioning;
import org.asynchttpclient.handler.AsyncHandlerExtensions;
import org.asynchttpclient.internal.chmv8.ConcurrentHashMapV8;
import org.asynchttpclient.netty.Callback;
import org.asynchttpclient.netty.NettyAsyncHttpProviderConfig;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.channel.Channels;
import org.asynchttpclient.netty.channel.CleanupChannelGroup;
import org.asynchttpclient.netty.channel.pool.ChannelPool;
import org.asynchttpclient.netty.channel.pool.ChannelPoolPartitionSelector;
import org.asynchttpclient.netty.channel.pool.DefaultChannelPool;
import org.asynchttpclient.netty.channel.pool.NoopChannelPool;
import org.asynchttpclient.netty.handler.HttpProtocol;
import org.asynchttpclient.netty.handler.Processor;
import org.asynchttpclient.netty.handler.WebSocketProtocol;
import org.asynchttpclient.netty.request.NettyRequestSender;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.AsyncHttpProviderUtils;
import org.asynchttpclient.util.HttpUtils;
import org.asynchttpclient.util.MiscUtils;
import org.asynchttpclient.util.PrefixIncrementThreadFactory;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.DefaultChannelFuture;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.BossPool;
import org.jboss.netty.channel.socket.nio.NioClientBossPool;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioWorkerPool;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.handler.codec.http.HttpClientCodec;
import org.jboss.netty.handler.codec.http.HttpContentDecompressor;
import org.jboss.netty.handler.codec.http.websocketx.WebSocket08FrameDecoder;
import org.jboss.netty.handler.codec.http.websocketx.WebSocket08FrameEncoder;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelManager.class);
    public static final String HTTP_HANDLER = "httpHandler";
    public static final String SSL_HANDLER = "sslHandler";
    public static final String HTTP_PROCESSOR = "httpProcessor";
    public static final String WS_PROCESSOR = "wsProcessor";
    public static final String DEFLATER_HANDLER = "deflater";
    public static final String INFLATER_HANDLER = "inflater";
    public static final String CHUNKED_WRITER_HANDLER = "chunkedWriter";
    public static final String WS_DECODER_HANDLER = "ws-decoder";
    public static final String WS_FRAME_AGGREGATOR = "ws-aggregator";
    public static final String WS_ENCODER_HANDLER = "ws-encoder";
    private final AsyncHttpClientConfig config;
    private final NettyAsyncHttpProviderConfig nettyConfig;
    private final SSLEngineFactory sslEngineFactory;
    private final ChannelPool channelPool;
    private final boolean maxTotalConnectionsEnabled;
    private final Semaphore freeChannels;
    private final ChannelGroup openChannels;
    private final boolean maxConnectionsPerHostEnabled;
    private final ConcurrentHashMapV8<Object, Semaphore> freeChannelsPerHost;
    private final ConcurrentHashMapV8<Integer, Object> channelId2PartitionKey;
    private final long handshakeTimeout;
    private final Timer nettyTimer;
    private final IOException tooManyConnections;
    private final IOException tooManyConnectionsPerHost;
    private final IOException poolAlreadyClosed;
    private final ClientSocketChannelFactory socketChannelFactory;
    private final boolean allowReleaseSocketChannelFactory;
    private final ClientBootstrap httpBootstrap;
    private final ClientBootstrap wsBootstrap;
    private final ConcurrentHashMapV8.Fun<Object, Semaphore> semaphoreComputer;
    private Processor wsProcessor;

    public ChannelManager(final AsyncHttpClientConfig config, NettyAsyncHttpProviderConfig nettyConfig, Timer nettyTimer) {
        this.config = config;
        this.nettyConfig = nettyConfig;
        this.nettyTimer = nettyTimer;
        this.sslEngineFactory = config.getSslEngineFactory() != null ? config.getSslEngineFactory() : new SSLEngineFactory.DefaultSSLEngineFactory(config);
        ChannelPool channelPool = nettyConfig.getChannelPool();
        if (channelPool == null && config.isAllowPoolingConnections()) {
            channelPool = new DefaultChannelPool(config, nettyTimer);
        } else if (channelPool == null) {
            channelPool = new NoopChannelPool();
        }
        this.channelPool = channelPool;
        this.tooManyConnections = MiscUtils.buildStaticIOException((String)String.format("Too many connections %s", config.getMaxConnections()));
        this.tooManyConnectionsPerHost = MiscUtils.buildStaticIOException((String)String.format("Too many connections per host %s", config.getMaxConnectionsPerHost()));
        this.poolAlreadyClosed = MiscUtils.buildStaticIOException((String)"Pool is already closed");
        this.maxTotalConnectionsEnabled = config.getMaxConnections() > 0;
        boolean bl = this.maxConnectionsPerHostEnabled = config.getMaxConnectionsPerHost() > 0;
        if (this.maxTotalConnectionsEnabled || this.maxConnectionsPerHostEnabled) {
            this.openChannels = new CleanupChannelGroup("asyncHttpClient"){

                public boolean remove(Object o) {
                    boolean removed = super.remove(o);
                    if (removed) {
                        Semaphore freeChannelsForHost;
                        Object partitionKey;
                        if (ChannelManager.this.maxTotalConnectionsEnabled) {
                            ChannelManager.this.freeChannels.release();
                        }
                        if (ChannelManager.this.maxConnectionsPerHostEnabled && (partitionKey = ChannelManager.this.channelId2PartitionKey.remove((Object)((Channel)Channel.class.cast(o)).getId())) != null && (freeChannelsForHost = (Semaphore)ChannelManager.this.freeChannelsPerHost.get(partitionKey)) != null) {
                            freeChannelsForHost.release();
                        }
                    }
                    return removed;
                }
            };
            this.freeChannels = new Semaphore(config.getMaxConnections());
        } else {
            this.openChannels = new CleanupChannelGroup("asyncHttpClient");
            this.freeChannels = null;
        }
        if (this.maxConnectionsPerHostEnabled) {
            this.freeChannelsPerHost = new ConcurrentHashMapV8();
            this.channelId2PartitionKey = new ConcurrentHashMapV8();
            this.semaphoreComputer = new ConcurrentHashMapV8.Fun<Object, Semaphore>(){

                public Semaphore apply(Object partitionKey) {
                    return new Semaphore(config.getMaxConnectionsPerHost());
                }
            };
        } else {
            this.freeChannelsPerHost = null;
            this.channelId2PartitionKey = null;
            this.semaphoreComputer = null;
        }
        this.handshakeTimeout = config.getHandshakeTimeout();
        if (nettyConfig.getSocketChannelFactory() != null) {
            this.socketChannelFactory = nettyConfig.getSocketChannelFactory();
            this.allowReleaseSocketChannelFactory = false;
        } else {
            ExecutorService e = nettyConfig.getBossExecutorService();
            if (e == null) {
                PrefixIncrementThreadFactory threadFactory = new PrefixIncrementThreadFactory(config.getNameOrDefault() + "-boss-");
                e = Executors.newCachedThreadPool((ThreadFactory)threadFactory);
            }
            int numWorkers = config.getIoThreadMultiplier() * Runtime.getRuntime().availableProcessors();
            LOGGER.trace("Number of application's worker threads is {}", (Object)numWorkers);
            NioClientBossPool nioClientBossPool = new NioClientBossPool((Executor)e, 1, (Timer)new HashedWheelTimer(), ThreadNameDeterminer.CURRENT);
            NioWorkerPool nioWorkerPool = new NioWorkerPool((Executor)config.getExecutorService(), numWorkers, ThreadNameDeterminer.CURRENT);
            this.socketChannelFactory = new NioClientSocketChannelFactory((BossPool)nioClientBossPool, (WorkerPool)nioWorkerPool);
            this.allowReleaseSocketChannelFactory = true;
        }
        this.httpBootstrap = new ClientBootstrap((ChannelFactory)this.socketChannelFactory);
        this.wsBootstrap = new ClientBootstrap((ChannelFactory)this.socketChannelFactory);
        DefaultChannelFuture.setUseDeadLockChecker((boolean)nettyConfig.isUseDeadLockChecker());
        if (config.getConnectTimeout() > 0) {
            nettyConfig.addProperty("connectTimeoutMillis", (Object)config.getConnectTimeout());
        }
        for (Map.Entry<String, Object> entry : nettyConfig.propertiesSet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            this.httpBootstrap.setOption(key, value);
            this.wsBootstrap.setOption(key, value);
        }
    }

    public void configureBootstraps(NettyRequestSender requestSender, AtomicBoolean closed) {
        HttpProtocol httpProtocol = new HttpProtocol(this, this.config, this.nettyConfig, requestSender);
        final Processor httpProcessor = new Processor(this.config, this, requestSender, httpProtocol);
        WebSocketProtocol wsProtocol = new WebSocketProtocol(this, this.config, this.nettyConfig, requestSender);
        this.wsProcessor = new Processor(this.config, this, requestSender, wsProtocol);
        this.httpBootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = org.jboss.netty.channel.Channels.pipeline();
                pipeline.addLast(ChannelManager.HTTP_HANDLER, (ChannelHandler)ChannelManager.this.newHttpClientCodec());
                pipeline.addLast(ChannelManager.INFLATER_HANDLER, (ChannelHandler)ChannelManager.this.newHttpContentDecompressor());
                pipeline.addLast(ChannelManager.CHUNKED_WRITER_HANDLER, (ChannelHandler)new ChunkedWriteHandler());
                pipeline.addLast(ChannelManager.HTTP_PROCESSOR, (ChannelHandler)httpProcessor);
                if (ChannelManager.this.nettyConfig.getHttpAdditionalPipelineInitializer() != null) {
                    ChannelManager.this.nettyConfig.getHttpAdditionalPipelineInitializer().initPipeline(pipeline);
                }
                return pipeline;
            }
        });
        this.wsBootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = org.jboss.netty.channel.Channels.pipeline();
                pipeline.addLast(ChannelManager.HTTP_HANDLER, (ChannelHandler)ChannelManager.this.newHttpClientCodec());
                pipeline.addLast(ChannelManager.WS_PROCESSOR, (ChannelHandler)ChannelManager.this.wsProcessor);
                if (ChannelManager.this.nettyConfig.getWsAdditionalPipelineInitializer() != null) {
                    ChannelManager.this.nettyConfig.getWsAdditionalPipelineInitializer().initPipeline(pipeline);
                }
                return pipeline;
            }
        });
    }

    private HttpContentDecompressor newHttpContentDecompressor() {
        if (this.config.isKeepEncodingHeader()) {
            return new HttpContentDecompressor(){

                protected String getTargetContentEncoding(String contentEncoding) throws Exception {
                    return contentEncoding;
                }
            };
        }
        return new HttpContentDecompressor();
    }

    public final void tryToOfferChannelToPool(Channel channel, AsyncHandler<?> handler, boolean keepAlive, Object partitionKey) {
        if (channel.isConnected() && keepAlive && channel.isReadable()) {
            LOGGER.debug("Adding key: {} for channel {}", partitionKey, (Object)channel);
            Channels.setDiscard(channel);
            if (handler instanceof AsyncHandlerExtensions) {
                ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(handler)).onConnectionOffer((Object)channel);
            }
            this.channelPool.offer(channel, partitionKey);
            if (this.maxConnectionsPerHostEnabled) {
                this.channelId2PartitionKey.putIfAbsent((Object)channel.getId(), partitionKey);
            }
        } else {
            this.closeChannel(channel);
        }
    }

    public Channel poll(Uri uri, String virtualHost, ProxyServer proxy, ConnectionPoolPartitioning connectionPoolPartitioning) {
        Object partitionKey = connectionPoolPartitioning.getPartitionKey(uri, virtualHost, proxy);
        return this.channelPool.poll(partitionKey);
    }

    public boolean removeAll(Channel connection) {
        return this.channelPool.removeAll(connection);
    }

    private boolean tryAcquireGlobal() {
        return !this.maxTotalConnectionsEnabled || this.freeChannels.tryAcquire();
    }

    private Semaphore getFreeConnectionsForHost(Object partitionKey) {
        return (Semaphore)this.freeChannelsPerHost.computeIfAbsent(partitionKey, this.semaphoreComputer);
    }

    private boolean tryAcquirePerHost(Object partitionKey) {
        return !this.maxConnectionsPerHostEnabled || this.getFreeConnectionsForHost(partitionKey).tryAcquire();
    }

    public void preemptChannel(Object partitionKey) throws IOException {
        if (!this.channelPool.isOpen()) {
            throw this.poolAlreadyClosed;
        }
        if (!this.tryAcquireGlobal()) {
            throw this.tooManyConnections;
        }
        if (!this.tryAcquirePerHost(partitionKey)) {
            if (this.maxTotalConnectionsEnabled) {
                this.freeChannels.release();
            }
            throw this.tooManyConnectionsPerHost;
        }
    }

    public void close() {
        this.channelPool.destroy();
        this.openChannels.close();
        for (Channel channel : this.openChannels) {
            Object attribute = Channels.getAttribute(channel);
            if (!(attribute instanceof NettyResponseFuture)) continue;
            NettyResponseFuture future = (NettyResponseFuture)((Object)attribute);
            future.cancelTimeouts();
        }
        this.config.getExecutorService().shutdown();
        if (this.allowReleaseSocketChannelFactory) {
            this.socketChannelFactory.releaseExternalResources();
            this.httpBootstrap.releaseExternalResources();
            this.wsBootstrap.releaseExternalResources();
        }
    }

    public void closeChannel(Channel channel) {
        LOGGER.debug("Closing Channel {} ", (Object)channel);
        try {
            this.removeAll(channel);
            Channels.setDiscard(channel);
            Channels.silentlyCloseChannel(channel);
        }
        catch (Throwable t) {
            LOGGER.debug("Error closing a connection", t);
        }
        this.openChannels.remove((Object)channel);
    }

    public void abortChannelPreemption(Object partitionKey) {
        if (this.maxTotalConnectionsEnabled) {
            this.freeChannels.release();
        }
        if (this.maxConnectionsPerHostEnabled) {
            this.getFreeConnectionsForHost(partitionKey).release();
        }
    }

    public void registerOpenChannel(Channel channel, Object partitionKey) {
        this.openChannels.add((Object)channel);
        if (this.maxConnectionsPerHostEnabled) {
            this.channelId2PartitionKey.put((Object)channel.getId(), partitionKey);
        }
    }

    private HttpClientCodec newHttpClientCodec() {
        return new HttpClientCodec(this.config.getHttpClientCodecMaxInitialLineLength(), this.config.getHttpClientCodecMaxHeaderSize(), this.config.getHttpClientCodecMaxChunkSize());
    }

    private SslHandler createSslHandler(String peerHost, int peerPort) throws GeneralSecurityException {
        SSLEngine sslEngine = this.sslEngineFactory.newSSLEngine(peerHost, peerPort);
        SslHandler sslHandler = this.handshakeTimeout > 0L ? new SslHandler(sslEngine, SslHandler.getDefaultBufferPool(), false, this.nettyTimer, this.handshakeTimeout) : new SslHandler(sslEngine);
        sslHandler.setCloseOnSSLException(true);
        return sslHandler;
    }

    public static boolean isSslHandlerConfigured(ChannelPipeline pipeline) {
        return pipeline.get(SSL_HANDLER) != null;
    }

    public void upgradeProtocol(ChannelPipeline pipeline, String scheme, String host, int port) throws GeneralSecurityException {
        if (pipeline.get(HTTP_HANDLER) != null) {
            pipeline.remove(HTTP_HANDLER);
        }
        if (HttpUtils.isSecure((String)scheme)) {
            if (ChannelManager.isSslHandlerConfigured(pipeline)) {
                pipeline.addAfter(SSL_HANDLER, HTTP_HANDLER, (ChannelHandler)this.newHttpClientCodec());
            } else {
                pipeline.addFirst(HTTP_HANDLER, (ChannelHandler)this.newHttpClientCodec());
                pipeline.addFirst(SSL_HANDLER, (ChannelHandler)this.createSslHandler(host, port));
            }
        } else {
            pipeline.addFirst(HTTP_HANDLER, (ChannelHandler)this.newHttpClientCodec());
        }
        if (HttpUtils.isWebSocket((String)scheme)) {
            pipeline.addAfter(HTTP_PROCESSOR, WS_PROCESSOR, (ChannelHandler)this.wsProcessor);
            pipeline.remove(HTTP_PROCESSOR);
        }
    }

    public SslHandler addSslHandler(ChannelPipeline pipeline, Uri uri, String virtualHost) throws GeneralSecurityException {
        int peerPort;
        String peerHost;
        if (virtualHost != null) {
            int i = virtualHost.indexOf(58);
            if (i == -1) {
                peerHost = virtualHost;
                peerPort = AsyncHttpProviderUtils.getSchemeDefaultPort((String)uri.getScheme());
            } else {
                peerHost = virtualHost.substring(0, i);
                peerPort = Integer.valueOf(virtualHost.substring(i + 1));
            }
        } else {
            peerHost = uri.getHost();
            peerPort = AsyncHttpProviderUtils.getExplicitPort((Uri)uri);
        }
        SslHandler sslHandler = this.createSslHandler(peerHost, peerPort);
        pipeline.addFirst(SSL_HANDLER, (ChannelHandler)sslHandler);
        return sslHandler;
    }

    public void verifyChannelPipeline(ChannelPipeline pipeline, Uri uri, String virtualHost) throws GeneralSecurityException {
        boolean sslHandlerConfigured = ChannelManager.isSslHandlerConfigured(pipeline);
        if (HttpUtils.isSecure((String)uri.getScheme())) {
            if (!sslHandlerConfigured) {
                this.addSslHandler(pipeline, uri, virtualHost);
            }
        } else if (sslHandlerConfigured) {
            pipeline.remove(SSL_HANDLER);
        }
    }

    public ClientBootstrap getBootstrap(String scheme, boolean useProxy) {
        return scheme.startsWith("ws") && !useProxy ? this.wsBootstrap : this.httpBootstrap;
    }

    public void upgradePipelineForWebSockets(ChannelPipeline pipeline) {
        pipeline.addAfter(HTTP_HANDLER, WS_ENCODER_HANDLER, (ChannelHandler)new WebSocket08FrameEncoder(true));
        pipeline.remove(HTTP_HANDLER);
        pipeline.addBefore(WS_PROCESSOR, WS_DECODER_HANDLER, (ChannelHandler)new WebSocket08FrameDecoder(false, false, (long)this.config.getWebSocketMaxFrameSize()));
        pipeline.addAfter(WS_DECODER_HANDLER, WS_FRAME_AGGREGATOR, (ChannelHandler)new WebSocketFrameAggregator(this.config.getWebSocketMaxBufferSize()));
    }

    public final Callback newDrainCallback(final NettyResponseFuture<?> future, final Channel channel, final boolean keepAlive, final Object partitionKey) {
        return new Callback(future){

            @Override
            public void call() {
                ChannelManager.this.tryToOfferChannelToPool(channel, future.getAsyncHandler(), keepAlive, partitionKey);
            }
        };
    }

    public void drainChannelAndOffer(Channel channel, NettyResponseFuture<?> future) {
        this.drainChannelAndOffer(channel, future, future.isKeepAlive(), future.getPartitionKey());
    }

    public void drainChannelAndOffer(Channel channel, NettyResponseFuture<?> future, boolean keepAlive, Object partitionKey) {
        Channels.setAttribute(channel, this.newDrainCallback(future, channel, keepAlive, partitionKey));
    }

    public void flushPartition(Object partitionKey) {
        this.channelPool.flushPartition(partitionKey);
    }

    public void flushPartitions(ChannelPoolPartitionSelector selector) {
        this.channelPool.flushPartitions(selector);
    }
}

