/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.netty.util.ChannelBufferUtils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpResponse;

public class NettyResponseBodyPart
extends HttpResponseBodyPart {
    private final boolean last;
    private final ChannelBuffer content;
    private volatile byte[] bytes;
    private final int length;
    private boolean closeConnection;

    public NettyResponseBodyPart(HttpResponse response, boolean last) {
        this(response, null, last);
    }

    public NettyResponseBodyPart(HttpResponse response, HttpChunk chunk, boolean last) {
        this.last = last;
        this.content = chunk != null ? chunk.getContent() : response.getContent();
        this.length = this.content.readableBytes();
    }

    public byte[] getBodyPartBytes() {
        if (this.bytes == null) {
            this.bytes = ChannelBufferUtils.channelBuffer2bytes(this.content);
        }
        return this.bytes;
    }

    public int writeTo(OutputStream outputStream) throws IOException {
        ChannelBuffer b = this.getChannelBuffer();
        int read = b.readableBytes();
        int index = b.readerIndex();
        if (read > 0) {
            b.readBytes(outputStream, read);
        }
        b.readerIndex(index);
        return read;
    }

    public ChannelBuffer getChannelBuffer() {
        return this.content;
    }

    public ByteBuffer getBodyByteBuffer() {
        return this.content.toByteBuffer();
    }

    public int length() {
        return this.length;
    }

    public InputStream readBodyPartBytes() {
        return new ByteArrayInputStream(this.bytes);
    }

    public boolean isLast() {
        return this.last;
    }

    public void markUnderlyingConnectionAsToBeClosed() {
        this.closeConnection = true;
    }

    public boolean isUnderlyingConnectionToBeClosed() {
        return this.closeConnection;
    }
}

