/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseHeaders;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.ResponseBase;
import org.asynchttpclient.cookie.Cookie;
import org.asynchttpclient.cookie.CookieDecoder;
import org.asynchttpclient.netty.NettyResponseBodyPart;
import org.asynchttpclient.netty.util.ChannelBufferUtils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.buffer.ChannelBuffers;

public class NettyResponse
extends ResponseBase {
    public NettyResponse(HttpResponseStatus status, HttpResponseHeaders headers, List<HttpResponseBodyPart> bodyParts) {
        super(status, headers, bodyParts);
    }

    public byte[] getResponseBodyAsBytes() throws IOException {
        return ChannelBufferUtils.channelBuffer2bytes(this.getResponseBodyAsChannelBuffer());
    }

    public ByteBuffer getResponseBodyAsByteBuffer() throws IOException {
        return this.getResponseBodyAsChannelBuffer().toByteBuffer();
    }

    public String getResponseBody() throws IOException {
        return this.getResponseBody(null);
    }

    public String getResponseBody(Charset charset) throws IOException {
        return this.getResponseBodyAsChannelBuffer().toString(this.calculateCharset(charset));
    }

    public InputStream getResponseBodyAsStream() throws IOException {
        return new ChannelBufferInputStream(this.getResponseBodyAsChannelBuffer());
    }

    public ChannelBuffer getResponseBodyAsChannelBuffer() throws IOException {
        ChannelBuffer b = null;
        switch (this.bodyParts.size()) {
            case 0: {
                b = ChannelBuffers.EMPTY_BUFFER;
                break;
            }
            case 1: {
                b = ((NettyResponseBodyPart)((Object)NettyResponseBodyPart.class.cast(this.bodyParts.get(0)))).getChannelBuffer();
                break;
            }
            default: {
                ChannelBuffer[] channelBuffers = new ChannelBuffer[this.bodyParts.size()];
                for (int i = 0; i < this.bodyParts.size(); ++i) {
                    channelBuffers[i] = ((NettyResponseBodyPart)((Object)NettyResponseBodyPart.class.cast(this.bodyParts.get(i)))).getChannelBuffer();
                }
                b = ChannelBuffers.wrappedBuffer((ChannelBuffer[])channelBuffers);
            }
        }
        return b;
    }

    protected List<Cookie> buildCookies() {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        for (Map.Entry header : this.headers.getHeaders().entrySet()) {
            if (!((String)header.getKey()).equalsIgnoreCase("Set-Cookie")) continue;
            List v = (List)header.getValue();
            for (String value : v) {
                cookies.add(CookieDecoder.decode((String)value));
            }
        }
        return cookies;
    }
}

