/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty;

import java.util.concurrent.atomic.AtomicBoolean;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.AsyncHttpProvider;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Request;
import org.asynchttpclient.netty.NettyAsyncHttpProviderConfig;
import org.asynchttpclient.netty.channel.ChannelManager;
import org.asynchttpclient.netty.channel.pool.ChannelPoolPartitionSelector;
import org.asynchttpclient.netty.request.NettyRequestSender;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyAsyncHttpProvider
extends SimpleChannelUpstreamHandler
implements AsyncHttpProvider {
    static final Logger LOGGER = LoggerFactory.getLogger(NettyAsyncHttpProvider.class);
    private final AsyncHttpClientConfig config;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ChannelManager channelManager;
    private final boolean allowStopNettyTimer;
    private final Timer nettyTimer;
    private final NettyRequestSender requestSender;

    public NettyAsyncHttpProvider(AsyncHttpClientConfig config) {
        this.config = config;
        NettyAsyncHttpProviderConfig nettyConfig = config.getAsyncHttpProviderConfig() instanceof NettyAsyncHttpProviderConfig ? (NettyAsyncHttpProviderConfig)config.getAsyncHttpProviderConfig() : new NettyAsyncHttpProviderConfig();
        this.allowStopNettyTimer = nettyConfig.getNettyTimer() == null;
        this.nettyTimer = this.allowStopNettyTimer ? this.newNettyTimer() : nettyConfig.getNettyTimer();
        this.channelManager = new ChannelManager(config, nettyConfig, this.nettyTimer);
        this.requestSender = new NettyRequestSender(config, this.channelManager, this.nettyTimer, this.closed);
        this.channelManager.configureBootstraps(this.requestSender, this.closed);
    }

    private Timer newNettyTimer() {
        HashedWheelTimer timer = new HashedWheelTimer();
        timer.start();
        return timer;
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.channelManager.close();
                this.config.getExecutorService().shutdown();
                if (this.allowStopNettyTimer) {
                    this.nettyTimer.stop();
                }
            }
            catch (Throwable t) {
                LOGGER.warn("Unexpected error on close", t);
            }
        }
    }

    public <T> ListenableFuture<T> execute(Request request, AsyncHandler<T> asyncHandler) {
        try {
            return this.requestSender.sendRequest(request, asyncHandler, null, false);
        }
        catch (Exception e) {
            asyncHandler.onThrowable((Throwable)e);
            return new ListenableFuture.CompletedFailure((Throwable)e);
        }
    }

    public void flushChannelPoolPartition(String partitionId) {
        this.channelManager.flushPartition(partitionId);
    }

    public void flushChannelPoolPartitions(ChannelPoolPartitionSelector selector) {
        this.channelManager.flushPartitions(selector);
    }
}

