/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.extras.rxjava2;

import io.reactivex.Maybe;
import io.reactivex.MaybeEmitter;
import io.reactivex.disposables.Disposables;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Request;
import org.asynchttpclient.extras.rxjava2.RxHttpClient;
import org.asynchttpclient.extras.rxjava2.maybe.MaybeAsyncHandlerBridge;
import org.asynchttpclient.extras.rxjava2.maybe.ProgressAsyncMaybeEmitterBridge;
import org.asynchttpclient.handler.ProgressAsyncHandler;

public class DefaultRxHttpClient
implements RxHttpClient {
    private final AsyncHttpClient asyncHttpClient;

    public DefaultRxHttpClient(AsyncHttpClient asyncHttpClient) {
        this.asyncHttpClient = Objects.requireNonNull(asyncHttpClient);
    }

    @Override
    public <T> Maybe<T> prepare(Request request, Supplier<? extends AsyncHandler<T>> handlerSupplier) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(handlerSupplier);
        return Maybe.create(emitter -> {
            AsyncHandler<?> bridge = this.createBridge(emitter, (AsyncHandler)handlerSupplier.get());
            ListenableFuture responseFuture = this.asyncHttpClient.executeRequest(request, bridge);
            emitter.setDisposable(Disposables.fromFuture((Future)responseFuture));
        });
    }

    protected <T> AsyncHandler<?> createBridge(MaybeEmitter<T> emitter, AsyncHandler<T> handler) {
        if (handler instanceof ProgressAsyncHandler) {
            return new ProgressAsyncMaybeEmitterBridge<T>(emitter, (ProgressAsyncHandler)handler);
        }
        return new MaybeAsyncHandlerBridge<T>(emitter, handler);
    }
}

