/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.extras.registry;

import java.lang.reflect.Constructor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpProvider;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.config.AsyncHttpClientConfig;
import org.asynchttpclient.extras.registry.AsyncHttpClientImplException;
import org.asynchttpclient.extras.registry.AsyncImplHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncHttpClientFactory {
    private static Class<AsyncHttpClient> asyncHttpClientImplClass = null;
    private static volatile boolean instantiated = false;
    public static final Logger logger = LoggerFactory.getLogger(AsyncHttpClientFactory.class);
    private static Lock lock = new ReentrantLock();

    public static AsyncHttpClient getAsyncHttpClient() {
        try {
            if (AsyncHttpClientFactory.attemptInstantiation()) {
                return asyncHttpClientImplClass.newInstance();
            }
        }
        catch (InstantiationException e) {
            throw new AsyncHttpClientImplException("Unable to create the class specified by system property : org.async.http.client.impl", e);
        }
        catch (IllegalAccessException e) {
            throw new AsyncHttpClientImplException("Unable to find the class specified by system property : org.async.http.client.impl", e);
        }
        return new DefaultAsyncHttpClient();
    }

    public static AsyncHttpClient getAsyncHttpClient(AsyncHttpProvider provider) {
        if (AsyncHttpClientFactory.attemptInstantiation()) {
            try {
                Constructor<AsyncHttpClient> constructor = asyncHttpClientImplClass.getConstructor(AsyncHttpProvider.class);
                return constructor.newInstance(provider);
            }
            catch (Exception e) {
                throw new AsyncHttpClientImplException("Unable to find the instantiate the class specified by system property : org.async.http.client.impl(AsyncHttpProvider) due to : " + e.getMessage(), e);
            }
        }
        return new DefaultAsyncHttpClient(provider);
    }

    public static AsyncHttpClient getAsyncHttpClient(AsyncHttpClientConfig config) {
        if (AsyncHttpClientFactory.attemptInstantiation()) {
            try {
                Constructor<AsyncHttpClient> constructor = asyncHttpClientImplClass.getConstructor(AsyncHttpClientConfig.class);
                return constructor.newInstance(config);
            }
            catch (Exception e) {
                throw new AsyncHttpClientImplException("Unable to find the instantiate the class specified by system property : org.async.http.client.impl(AsyncHttpProvider) due to : " + e.getMessage(), e);
            }
        }
        return new DefaultAsyncHttpClient(config);
    }

    public static AsyncHttpClient getAsyncHttpClient(AsyncHttpProvider provider, AsyncHttpClientConfig config) {
        if (AsyncHttpClientFactory.attemptInstantiation()) {
            try {
                Constructor<AsyncHttpClient> constructor = asyncHttpClientImplClass.getConstructor(AsyncHttpProvider.class, AsyncHttpClientConfig.class);
                return constructor.newInstance(provider, config);
            }
            catch (Exception e) {
                throw new AsyncHttpClientImplException("Unable to find the instantiate the class specified by system property : org.async.http.client.impl(AsyncHttpProvider) due to : " + e.getMessage(), e);
            }
        }
        return new DefaultAsyncHttpClient(provider, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean attemptInstantiation() {
        if (!instantiated) {
            lock.lock();
            try {
                if (!instantiated) {
                    asyncHttpClientImplClass = AsyncImplHelper.getAsyncImplClass("org.async.http.client.impl");
                    instantiated = true;
                }
            }
            finally {
                lock.unlock();
            }
        }
        return asyncHttpClientImplClass != null;
    }
}

