package org.arquillian.spacelift.gradle.git

import java.util.logging.Logger

import org.arquillian.spacelift.Spacelift
import org.arquillian.spacelift.execution.ExecutionException
import org.arquillian.spacelift.process.Command
import org.arquillian.spacelift.process.CommandBuilder
import org.arquillian.spacelift.task.Task
import org.arquillian.spacelift.task.os.CommandTool

/**
 * Checkouts some branch. If {@link #checkout(String)} is not called, it is checked out to master.
 *
 * @author <a href="mailto:smikloso@redhat.com">Stefan Miklosovic</a>
 *
 */
class GitCheckoutTool extends Task<File, File> {

    private static Logger logger = Logger.getLogger(GitCheckoutTool.class.getName())

    String branch = "master"
    boolean force = false

    /**
     *
     * @param branch , branch to check out, it is skipped when it is null object or it is empty string.
     * @return
     */
    GitCheckoutTool checkout(String branch) {
        if (notNullAndNotEmpty(branch)) {
            this.branch = branch
        }
        return this
    }

    GitCheckoutTool force() {
        this.force = true
        return this
    }

    @Override
    protected File process(File repositoryDir) throws Exception {

        CommandBuilder command = new CommandBuilder("git")
                .parameter("checkout")
                .parameter(branch)

        if(force) {
            command.parameter('--force')
        }

        logger.info(command.toString())

        try {
            Spacelift.task(CommandTool).workingDirectory(repositoryDir).command(command).execute().await()
        } catch (ExecutionException ex) {
            throw new ExecutionException(
                    ex, "Checking out branch '{0}' in repository '{1}' was not successful. Command '{2}'.", branch,
                    repositoryDir.getAbsolutePath(), command.toString())
        }

        repositoryDir
    }

    private boolean notNullAndNotEmpty(String value) {
        value && !value.isEmpty()
    }
}
