/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.selendroid;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.configuration.Command;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.droidium.container.impl.ProcessExecutor;
import org.arquillian.droidium.container.utils.DroidiumFileUtils;
import org.arquillian.droidium.native_.selendroid.SelendroidRebuilderException;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class SelendroidRebuilder {
    private static final Logger logger = Logger.getLogger(SelendroidRebuilder.class.getName());
    private final ProcessExecutor processExecutor;
    private final AndroidSDK androidSDK;
    public static final String SELENDROID_PACKAGE_NAME = "package=\"io.selendroid\"";
    public static final String SELENDROID_TEST_PACKAGE = "io.selendroid.testapp";
    public static final String ICON = "android:icon=\"@drawable/selenium_icon\"";

    public SelendroidRebuilder(ProcessExecutor processExecutor, AndroidSDK androidSDK) {
        Validate.notNull((Object)processExecutor, (String)"Process exeuctor for Selendroid rebuilder can not be a null object!");
        Validate.notNull((Object)androidSDK, (String)"Android SDK for Selendroid rebuilder can not be null a null object!");
        this.processExecutor = processExecutor;
        this.androidSDK = androidSDK;
    }

    public File rebuild(File selendroidWorkingCopy, String selendroidPackageName, String applicationBasePackage) {
        FileOutputStream toBeReplacedAndroidManifestStream;
        Validate.notNull((Object)selendroidWorkingCopy, (String)"Working copy of Selendroid server to rebuild can not be a null object!");
        Validate.notNullOrEmpty((String)selendroidPackageName, (String)"Selendroid package name for rebuilding of Selendroid server can not be a null object nor an empty string!");
        Validate.notNullOrEmpty((String)applicationBasePackage, (String)"Application base package for rebuilding of Selendroid server can not be a null object nor an empty string!");
        File toBeReplacedAndroidManifest = new File(DroidiumFileUtils.getTmpDir(), "AndroidManifestToBeReplaced.xml");
        File finalAndroidManifest = new File(DroidiumFileUtils.getTmpDir(), "AndroidManifest.xml");
        File dummyAPK = new File(DroidiumFileUtils.getTmpDir(), "dummy.apk");
        try {
            toBeReplacedAndroidManifestStream = new FileOutputStream(toBeReplacedAndroidManifest.getAbsoluteFile());
        }
        catch (FileNotFoundException ex) {
            throw new SelendroidRebuilderException();
        }
        InputStream androidManifestStream = this.getClass().getClassLoader().getResourceAsStream("AndroidManifest.xml");
        if (androidManifestStream == null) {
            throw new SelendroidRebuilderException("the class loader of " + this.getClass().getName() + " could not find AndroidManifest.xml resource");
        }
        try {
            toBeReplacedAndroidManifestStream.write(IOUtils.toByteArray((InputStream)androidManifestStream));
        }
        catch (IOException ex) {
            throw new SelendroidRebuilderException("unable to write to " + toBeReplacedAndroidManifest.getAbsolutePath());
        }
        this.closeStream(toBeReplacedAndroidManifestStream);
        this.closeStream(androidManifestStream);
        this.filter(toBeReplacedAndroidManifest, finalAndroidManifest, selendroidPackageName, applicationBasePackage);
        this.createDummyAPK(dummyAPK, finalAndroidManifest);
        Archive dummyArchive = (Archive)ShrinkWrap.createFromZipFile(JavaArchive.class, (File)dummyAPK);
        Archive finalArchive = (Archive)ShrinkWrap.createFromZipFile(JavaArchive.class, (File)selendroidWorkingCopy);
        finalArchive.delete("AndroidManifest.xml");
        finalArchive.add(dummyArchive.get("AndroidManifest.xml").getAsset(), "AndroidManifest.xml");
        File targetFile = new File(DroidiumFileUtils.getTmpDir(), DroidiumFileUtils.getRandomAPKFileName());
        return DroidiumFileUtils.export((Archive)finalArchive, (File)targetFile);
    }

    private void createDummyAPK(File dummyAPK, File androidManifest) {
        Command createDummyPackage = new Command();
        createDummyPackage.add(this.androidSDK.getAaptPath()).add("package").add("-f").add("-M").add(androidManifest.getAbsolutePath()).add("-I").add(this.androidSDK.getPlatform() + "/android.jar").add("-F").add(dummyAPK.getAbsolutePath());
        try {
            this.processExecutor.execute(createDummyPackage.getAsArray());
        }
        catch (InterruptedException e) {
            throw new SelendroidRebuilderException("Command was interrupted: " + createDummyPackage.toString());
        }
        catch (ExecutionException e) {
            throw new SelendroidRebuilderException("Command failed to execute: " + createDummyPackage.toString());
        }
    }

    private void filter(File toBeReplaced, File finalManifest, String selendroidPackageName, String applicationBasePackage) {
        try {
            ManifestFilter filter = new ManifestFilter(FileUtils.readLines((File)toBeReplaced));
            filter.filter(SELENDROID_PACKAGE_NAME, "package=\"" + selendroidPackageName + "\"").filter(SELENDROID_TEST_PACKAGE, applicationBasePackage).filter(ICON, "");
            if (logger.isLoggable(Level.FINE)) {
                for (String line : filter.getFiltered()) {
                    System.out.println(line);
                }
            }
            FileUtils.writeLines((File)finalManifest, filter.getFiltered());
        }
        catch (IOException e) {
            throw new SelendroidRebuilderException("Unable to filter Android manifest. Tried to filter " + toBeReplaced.getAbsolutePath() + " into " + finalManifest.getAbsolutePath() + ".");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStream(Closeable stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
        }
        finally {
            stream = null;
        }
    }

    protected static class Replacer {
        protected Replacer() {
        }

        public static List<String> replace(List<String> lines, String toReplace, String replacement) {
            Validate.notNullOrEmpty((String)toReplace, (String)"The string to be replaced can not be a null object nor an empty string!");
            Validate.notNull((Object)replacement, (String)"The string as a replacement can not be a null object!");
            Validate.notNull(lines, (String)("The list to be filtered for the replacement of '" + toReplace + "' for '" + replacement + "' can not be a null object!"));
            if (lines.size() == 0) {
                return null;
            }
            ArrayList<String> filtered = new ArrayList<String>();
            for (String line : lines) {
                filtered.add(line.replaceAll(toReplace, replacement));
            }
            return filtered;
        }
    }

    protected class ManifestFilter {
        private List<String> manifest;

        public ManifestFilter(List<String> manifest) {
            this.manifest = manifest;
        }

        public ManifestFilter filter(String toReplace, String replacement) {
            this.manifest = Replacer.replace(this.manifest, toReplace, replacement);
            return this;
        }

        public List<String> getFiltered() {
            return this.manifest;
        }
    }
}

