/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.deployment;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.native_.deployment.DeploymentWebDriverMapper;
import org.arquillian.droidium.native_.instrumentation.DeploymentInstrumentationMapper;
import org.arquillian.droidium.native_.spi.InstrumentationConfiguration;
import org.arquillian.droidium.native_.spi.event.AfterExtensionDroneMapping;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class DeploymentWebDriverResolver {
    private static final Logger logger = Logger.getLogger(DeploymentWebDriverResolver.class.getName());
    @Inject
    private Instance<DeploymentWebDriverMapper> deploymentWebDriverMapper;
    @Inject
    private Instance<DeploymentInstrumentationMapper> deploymentInstrumentationMapper;

    public void resolveDeploymentWebDriverMap(@Observes AfterExtensionDroneMapping event) {
        for (Map.Entry<String, InstrumentationConfiguration> entry : ((DeploymentInstrumentationMapper)this.deploymentInstrumentationMapper.get()).get().entrySet()) {
            if (!entry.getValue().getPort().equals(event.getPort())) continue;
            ((DeploymentWebDriverMapper)this.deploymentWebDriverMapper.get()).add(entry.getKey(), event.getExtensionName());
        }
        if (logger.isLoggable(Level.FINE)) {
            for (Map.Entry<String, Object> entry : ((DeploymentWebDriverMapper)this.deploymentWebDriverMapper.get()).get().entrySet()) {
                System.out.println("Deployment name: " + entry.getKey() + "\n" + "Extension qualifier: " + (String)entry.getValue());
            }
        }
    }
}

