/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class Command {
    private List<String> command;

    public Command() {
        this.command = new ArrayList<String>();
    }

    public Command(List<String> command) throws IllegalArgumentException {
        if (command == null) {
            throw new IllegalArgumentException("command can't be a null list!");
        }
        this.command = command;
    }

    public Command add(String token) {
        if (token != null && !token.trim().equals("")) {
            this.command.add(token.trim());
        }
        return this;
    }

    public Command add(List<String> tokens) {
        for (String token : tokens) {
            this.add(token);
        }
        return this;
    }

    public Command addAsString(String tokens) {
        int i;
        if (tokens == null || tokens.trim().equals("")) {
            return this;
        }
        tokens = this.deleteTrailingSpaces(tokens);
        ArrayList<String> tokenized = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(this.deleteTrailingSpaces(tokens), " ");
        while (tokenizer.hasMoreTokens()) {
            tokenized.add(tokenizer.nextToken().trim());
        }
        int quotesOnEnds = 0;
        int quotesTotal = 0;
        for (i = 0; i < tokenized.size(); ++i) {
            if (((String)tokenized.get(i)).startsWith("\"")) {
                ++quotesOnEnds;
            }
            if (((String)tokenized.get(i)).endsWith("\"")) {
                ++quotesOnEnds;
            }
            for (int j = 0; j < ((String)tokenized.get(i)).length(); ++j) {
                if (((String)tokenized.get(i)).charAt(j) != '\"') continue;
                ++quotesTotal;
            }
        }
        if (quotesOnEnds != quotesTotal) {
            return this;
        }
        if (quotesOnEnds % 2 != 0) {
            return this;
        }
        for (i = 0; i < tokenized.size(); ++i) {
            if (((String)tokenized.get(i)).startsWith("\"")) {
                if (((String)tokenized.get(i)).endsWith("\"")) {
                    this.command.add((String)tokenized.get(i));
                    continue;
                }
                StringBuilder sb = new StringBuilder();
                sb.append((String)tokenized.get(i));
                int j = i;
                while (true) {
                    if (((String)tokenized.get(++j)).endsWith("\"")) break;
                    sb.append(" ").append((String)tokenized.get(j)).append(" ");
                }
                sb.append(" ").append((String)tokenized.get(j));
                this.command.add(sb.toString());
                ++i;
                continue;
            }
            this.command.add((String)tokenized.get(i));
        }
        return this;
    }

    private String deleteTrailingSpaces(String text) {
        if (text == null) {
            return null;
        }
        return text.replaceAll("^ +| +$|( )+", "$1").replaceAll("\" ([^\"])", "\"$1").replaceAll("\"([^ \"]) \"", "\"$1\"");
    }

    public Command remove(String token) {
        if (token == null || token.trim().equals("")) {
            return this;
        }
        while (this.command.remove(token)) {
        }
        return this;
    }

    public Command clear() {
        this.command.clear();
        return this;
    }

    public int size() {
        return this.command.size();
    }

    public List<String> getAsList() {
        return this.command;
    }

    public String[] getAsArray() {
        return this.getAsList().toArray(new String[0]);
    }

    public String getAsString() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.command) {
            sb.append(s);
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    public String get(int i) {
        try {
            return this.command.get(i);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    public String getLast() {
        if (this.command.isEmpty()) {
            return null;
        }
        return this.command.get(this.command.size() - 1);
    }

    public String getFirst() {
        if (this.command.isEmpty()) {
            return null;
        }
        return this.command.get(0);
    }

    public String toString() {
        return this.getAsString();
    }
}

