/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.sign;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.droidium.native_.configuration.DroidiumNativeConfiguration;
import org.arquillian.droidium.native_.utils.Command;

public final class KeyStoreCreator {
    private static final Logger logger = Logger.getLogger(KeyStoreCreator.class.getName());
    private final AndroidSDK sdk;
    private final DroidiumNativeConfiguration configuration;

    public KeyStoreCreator(AndroidSDK sdk, DroidiumNativeConfiguration configuration) {
        Validate.notNull((Object)sdk, (String)"Android sdk for key store creator can not be a null object!");
        Validate.notNull((Object)configuration, (String)"Droidium native configuration for key store creator can not be a null object!");
        this.sdk = sdk;
        this.configuration = configuration;
    }

    public boolean keyStoreExists(File keyStore) {
        try {
            Validate.isReadable((File)keyStore, (String)("You must provide a valid path to keystore for signing of APK files: '" + keyStore.getAbsolutePath() + "."));
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createKeyStore(File keyStoreToCreate) {
        Command createKeyStoreCommand = new Command();
        createKeyStoreCommand.add(this.sdk.getPathForJavaTool("keytool")).add("-genkey").add("-v").add("-keystore").add(keyStoreToCreate.getAbsolutePath()).add("-storepass").add(this.configuration.getStorepass()).add("-alias").add(this.configuration.getAlias()).add("-keypass").add(this.configuration.getKeypass()).add("-dname").addAsString("CN=Android,O=Android,C=US").add("-storetype").add("JKS").add("-sigalg").add(this.configuration.getSigalg()).add("-keyalg").add(this.configuration.getKeyalg());
        logger.log(Level.INFO, createKeyStoreCommand.toString());
        BufferedReader bufferedReader = null;
        try {
            String line;
            ProcessBuilder builder = new ProcessBuilder(createKeyStoreCommand.getAsList());
            Process process = builder.start();
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = bufferedReader.readLine()) != null) {
                if (!logger.isLoggable(Level.FINE)) continue;
                System.out.println(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException ex) {
                }
                finally {
                    bufferedReader = null;
                }
            }
        }
    }
}

