/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.sign;

import java.io.File;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.droidium.container.impl.ProcessExecutor;
import org.arquillian.droidium.native_.configuration.DroidiumNativeConfiguration;
import org.arquillian.droidium.native_.sign.APKSignerException;
import org.arquillian.droidium.native_.sign.KeyStoreCreator;
import org.arquillian.droidium.native_.utils.Command;
import org.arquillian.droidium.native_.utils.DroidiumNativeFileUtils;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class APKSigner {
    private static final Logger logger = Logger.getLogger(APKSigner.class.getName());
    private final AndroidSDK sdk;
    private final DroidiumNativeConfiguration configuration;
    private final ProcessExecutor executor;

    public APKSigner(ProcessExecutor executor, AndroidSDK sdk, DroidiumNativeConfiguration configuration) throws IllegalArgumentException {
        Validate.notNull((Object)executor, (String)"Process executor to set can not be a null object!");
        Validate.notNull((Object)sdk, (String)"Android SDK to set can not be a null object!");
        Validate.notNull((Object)configuration, (String)"Droidium native configuration to set can not be a null object!");
        this.executor = executor;
        this.sdk = sdk;
        this.configuration = configuration;
    }

    public File sign(File toSign, File signed) {
        this.checkKeyStore();
        Command jarSignerCommand = new Command();
        jarSignerCommand.add(this.sdk.getPathForJavaTool("jarsigner")).add("-sigalg").add("MD5withRSA").add("-digestalg").add("SHA1").add("-signedjar").add(signed.getAbsolutePath()).add("-storepass").add(this.configuration.getStorepass()).add("-keystore").add(this.configuration.getKeystore().getAbsolutePath()).add(toSign.getAbsolutePath()).add(this.configuration.getAlias());
        logger.log(Level.FINE, jarSignerCommand.toString());
        try {
            this.executor.execute(jarSignerCommand.getAsList().toArray(new String[0]));
        }
        catch (InterruptedException ex) {
            throw new APKSignerException("Signing process was interrupted.", ex);
        }
        catch (ExecutionException ex) {
            throw new APKSignerException("Unable to sign package, signing process failed.", ex);
        }
        return signed;
    }

    public File resign(File toResign, File resigned) {
        Archive apk = (Archive)ShrinkWrap.createFromZipFile(JavaArchive.class, (File)toResign);
        apk.delete("META-INF");
        DroidiumNativeFileUtils.export(apk, toResign);
        return this.sign(toResign, resigned);
    }

    private void checkKeyStore() {
        KeyStoreCreator keyStoreCreator = new KeyStoreCreator(this.sdk, this.configuration);
        if (!keyStoreCreator.keyStoreExists(this.configuration.getKeystore())) {
            File defaultKeyStore = new File(this.getDefaultKeyStorePath());
            if (!keyStoreCreator.keyStoreExists(defaultKeyStore)) {
                keyStoreCreator.createKeyStore(defaultKeyStore);
            }
            this.configuration.setProperty("keyStore", defaultKeyStore.getAbsolutePath());
        }
    }

    private String getDefaultKeyStorePath() {
        String separator = System.getProperty("file.separator");
        return System.getProperty("user.home") + separator + ".android" + separator + "debug.keystore";
    }
}

