/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.deployment;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.arquillian.droidium.native_.configuration.DroneConfigurationHolder;
import org.jboss.arquillian.core.spi.Validate;

public class ExtensionDroneMapper {
    private static final Logger logger = Logger.getLogger(ExtensionDroneMapper.class.getName());
    private static final Map<String, DroneConfigurationHolder> map = new ConcurrentHashMap<String, DroneConfigurationHolder>();

    public void put(String extensionQualifier, DroneConfigurationHolder configuration) {
        Validate.notNullOrEmpty((String)extensionQualifier, (String)"Extension qualifier you want to map to Drone configuration can not be a null object nor an empty string!");
        Validate.notNull((Object)configuration, (String)"Configuration you are trying to map with extension qualifier can not be a null object!");
        if (!this.isValid(configuration)) {
            logger.info("You are trying to put invalid mapping. Drone configuration validation process failed. You tried to put: " + configuration.toString());
        }
        if (map.containsKey(extensionQualifier)) {
            logger.fine("You are trying to put extensionQualifier-drone config pair into the mapper but there is already such extension qualifier stored.");
        }
        map.put(extensionQualifier, configuration);
    }

    public Map<String, DroneConfigurationHolder> get() {
        return map;
    }

    public DroneConfigurationHolder getConfiguration(String extensionQualifier) {
        Validate.notNullOrEmpty((String)extensionQualifier, (String)"Extension qualifier you are trying to get the configuration of can not be a null object nor an empty string!");
        return map.get(extensionQualifier);
    }

    public String getExtensionQualifierForPort(String port) {
        for (Map.Entry<String, DroneConfigurationHolder> entry : map.entrySet()) {
            if (!entry.getValue().getPort().equals(port)) continue;
            return entry.getKey();
        }
        return null;
    }

    public String getExtensionQualifierForDroneQualifer(String droneQualifier) {
        for (Map.Entry<String, DroneConfigurationHolder> entry : map.entrySet()) {
            if (!entry.getValue().getQualifier().equals(droneQualifier)) continue;
            return entry.getKey();
        }
        return null;
    }

    private boolean isValid(DroneConfigurationHolder configuration) {
        if (configuration == null) {
            return false;
        }
        try {
            Validate.notNullOrEmpty((String)configuration.getDroneType(), (String)"Type of Drone can not be a null object nor an empty sring!");
            Validate.notNullOrEmpty((String)configuration.getQualifier(), (String)"Qualifier of Drone can not be a null object nor an empty string!");
            Validate.notNullOrEmpty((String)configuration.getPort(), (String)"Port where Drone instance is supposed to be hooked can not be a null object nor an empty string!");
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
        return true;
    }
}

