/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.deployment;

import java.io.File;
import org.arquillian.droidium.container.spi.event.AndroidDeploy;
import org.arquillian.droidium.native_.android.AndroidApplicationHelper;
import org.arquillian.droidium.native_.android.AndroidApplicationManager;
import org.arquillian.droidium.native_.deployment.AndroidDeploymentRegister;
import org.arquillian.droidium.native_.sign.APKSigner;
import org.arquillian.droidium.native_.spi.AndroidDeployment;
import org.arquillian.droidium.native_.spi.event.AfterAndroidDeploymentDeployed;
import org.arquillian.droidium.native_.spi.event.BeforeAndroidDeploymentDeployed;
import org.arquillian.droidium.native_.utils.DroidiumNativeFileUtils;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.shrinkwrap.api.Archive;

public class AndroidDeploymentInstaller {
    @Inject
    private Instance<APKSigner> signer;
    @Inject
    private Instance<AndroidApplicationHelper> androidApplicationHelper;
    @Inject
    private Instance<AndroidApplicationManager> androidApplicationManager;
    @Inject
    private Instance<AndroidDeploymentRegister> androidDeploymentRegister;
    @Inject
    private Event<BeforeAndroidDeploymentDeployed> beforeAndroidDeployment;
    @Inject
    private Event<AfterAndroidDeploymentDeployed> afterAndroidDeployment;

    public void onAndroidDeployArchive(@Observes AndroidDeploy event, DeploymentDescription description) {
        this.beforeAndroidDeployment.fire((Object)new BeforeAndroidDeploymentDeployed(event.getArchive()));
        Archive archive = event.getArchive();
        File deployApk = DroidiumNativeFileUtils.export(archive, new File(DroidiumNativeFileUtils.getTmpDir(), DroidiumNativeFileUtils.getRandomAPKFileName()));
        File resignedApk = ((APKSigner)this.signer.get()).resign(deployApk, new File(DroidiumNativeFileUtils.getTmpDir(), DroidiumNativeFileUtils.getRandomAPKFileName()));
        AndroidDeployment deployment = new AndroidDeployment();
        deployment.setDeployment(archive).setDeployApk(deployApk).setResignedApk(resignedApk).setApplicationBasePackage(((AndroidApplicationHelper)this.androidApplicationHelper.get()).getApplicationBasePackage(resignedApk)).setDeploymentName(description.getName());
        ((AndroidDeploymentRegister)this.androidDeploymentRegister.get()).add(deployment);
        ((AndroidApplicationManager)this.androidApplicationManager.get()).install(deployment);
        this.afterAndroidDeployment.fire((Object)new AfterAndroidDeploymentDeployed(resignedApk));
    }
}

