/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.native_.deployment;

import java.util.List;
import org.arquillian.droidium.native_.android.AndroidApplicationHelper;
import org.arquillian.droidium.native_.deployment.ActivityDeploymentMapper;
import org.arquillian.droidium.native_.instrumentation.DeploymentInstrumentationMapper;
import org.arquillian.droidium.native_.spi.event.AfterAndroidDeploymentDeployed;
import org.arquillian.droidium.native_.spi.event.AfterAndroidDeploymentScanned;
import org.arquillian.droidium.native_.spi.event.BeforeAndroidDeploymentScanned;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class ActivityDeploymentScanner {
    @Inject
    private Instance<ActivityDeploymentMapper> activityDeploymentMapper;
    @Inject
    private Instance<DeploymentInstrumentationMapper> instrumentationMapper;
    @Inject
    private Instance<AndroidApplicationHelper> androidApplicationHelper;
    @Inject
    private Event<BeforeAndroidDeploymentScanned> beforeAndroidDeploymentScanned;
    @Inject
    private Event<AfterAndroidDeploymentScanned> afterAndroidDeploymentScanned;

    public void onAndroidDeploymentDeployed(@Observes AfterAndroidDeploymentDeployed event, DeploymentDescription description) {
        this.beforeAndroidDeploymentScanned.fire((Object)new BeforeAndroidDeploymentScanned(event.getDeployed()));
        if (((DeploymentInstrumentationMapper)this.instrumentationMapper.get()).getDeploymentName(description.getName()) != null) {
            List<String> activities = ((AndroidApplicationHelper)this.androidApplicationHelper.get()).getActivities(event.getDeployed());
            ActivityDeploymentMapper activityDeploymentMapper = (ActivityDeploymentMapper)this.activityDeploymentMapper.get();
            for (String activity : activities) {
                activityDeploymentMapper.put(activity, description.getName());
            }
            this.afterAndroidDeploymentScanned.fire((Object)new AfterAndroidDeploymentScanned(event.getDeployed()));
        }
    }
}

